/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.reader;

import org.apache.samza.SamzaException;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.hdfs.reader.AvroFileHdfsReader;
import org.apache.samza.system.hdfs.reader.SingleFileHdfsReader;

public class HdfsReaderFactory {
    public static SingleFileHdfsReader getHdfsReader(ReaderType readerType, SystemStreamPartition systemStreamPartition) {
        switch (readerType) {
            case AVRO: {
                return new AvroFileHdfsReader(systemStreamPartition);
            }
        }
        throw new SamzaException("Unsupported reader type: " + (Object)((Object)readerType));
    }

    public static ReaderType getType(String readerTypeStr) {
        try {
            return ReaderType.valueOf(readerTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SamzaException("Invalid hdfs reader type string: " + readerTypeStr, (Throwable)e);
        }
    }

    public static int offsetComparator(ReaderType readerType, String offset1, String offset2) {
        switch (readerType) {
            case AVRO: {
                return AvroFileHdfsReader.offsetComparator(offset1, offset2);
            }
        }
        throw new SamzaException("Unsupported reader type: " + (Object)((Object)readerType));
    }

    public static enum ReaderType {
        AVRO;

    }
}

