/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.reader;

import java.util.List;
import org.apache.samza.SamzaException;
import org.apache.samza.system.IncomingMessageEnvelope;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.system.hdfs.HdfsConfig;
import org.apache.samza.system.hdfs.reader.HdfsReaderFactory;
import org.apache.samza.system.hdfs.reader.SingleFileHdfsReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileHdfsReader {
    private static final Logger LOG = LoggerFactory.getLogger(MultiFileHdfsReader.class);
    private static final String DELIMITER = ":";
    private final HdfsReaderFactory.ReaderType readerType;
    private final SystemStreamPartition systemStreamPartition;
    private final List<String> filePaths;
    private SingleFileHdfsReader curReader;
    private int curFileIndex = 0;
    private String curSingleFileOffset;
    private int numRetries;
    private int numMaxRetries;

    public static int getCurFileIndex(String offset) {
        String[] elements = offset.split(DELIMITER);
        if (elements.length < 2) {
            throw new SamzaException("Invalid offset for MultiFileHdfsReader: " + offset);
        }
        return Integer.parseInt(elements[0]);
    }

    public static String getCurSingleFileOffset(String offset) {
        String[] elements = offset.split(DELIMITER);
        if (elements.length < 2) {
            throw new SamzaException("Invalid offset for MultiFileHdfsReader: " + offset);
        }
        return offset.substring(elements[0].length() + 1);
    }

    public static String generateOffset(int fileIndex, String singleFileOffset) {
        return fileIndex + DELIMITER + singleFileOffset;
    }

    private String getCurOffset() {
        return MultiFileHdfsReader.generateOffset(this.curFileIndex, this.curSingleFileOffset);
    }

    public MultiFileHdfsReader(HdfsReaderFactory.ReaderType readerType, SystemStreamPartition systemStreamPartition, List<String> partitionDescriptors, String offset) {
        this(readerType, systemStreamPartition, partitionDescriptors, offset, Integer.parseInt(HdfsConfig.CONSUMER_NUM_MAX_RETRIES_DEFAULT()));
    }

    private void init(String offset) {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
        this.curFileIndex = MultiFileHdfsReader.getCurFileIndex(offset);
        if (this.curFileIndex >= this.filePaths.size()) {
            throw new SamzaException(String.format("Invalid file index %d. Number of files is %d", this.curFileIndex, this.filePaths.size()));
        }
        this.curSingleFileOffset = MultiFileHdfsReader.getCurSingleFileOffset(offset);
        this.curReader = HdfsReaderFactory.getHdfsReader(this.readerType, this.systemStreamPartition);
        this.curReader.open(this.filePaths.get(this.curFileIndex), this.curSingleFileOffset);
    }

    public MultiFileHdfsReader(HdfsReaderFactory.ReaderType readerType, SystemStreamPartition systemStreamPartition, List<String> partitionDescriptors, String offset, int numMaxRetries) {
        this.readerType = readerType;
        this.systemStreamPartition = systemStreamPartition;
        this.filePaths = partitionDescriptors;
        this.numMaxRetries = numMaxRetries;
        this.numRetries = 0;
        if (partitionDescriptors.isEmpty()) {
            throw new SamzaException("Invalid number of files based on partition descriptors: " + partitionDescriptors.size());
        }
        this.init(offset);
    }

    public boolean hasNext() {
        while (this.curFileIndex < this.filePaths.size()) {
            if (this.curReader.hasNext()) {
                return true;
            }
            this.curReader.close();
            ++this.curFileIndex;
            if (this.curFileIndex >= this.filePaths.size()) continue;
            this.curReader = HdfsReaderFactory.getHdfsReader(this.readerType, this.systemStreamPartition);
            this.curReader.open(this.filePaths.get(this.curFileIndex), "0");
        }
        return false;
    }

    public IncomingMessageEnvelope readNext() {
        if (!this.hasNext()) {
            LOG.warn("Attempting to read more data when there aren't any. ssp=" + this.systemStreamPartition);
            return null;
        }
        this.curSingleFileOffset = this.curReader.nextOffset();
        IncomingMessageEnvelope messageEnvelope = this.curReader.readNext();
        return new IncomingMessageEnvelope(messageEnvelope.getSystemStreamPartition(), this.getCurOffset(), messageEnvelope.getKey(), messageEnvelope.getMessage(), messageEnvelope.getSize(), messageEnvelope.getEventTime(), messageEnvelope.getArrivalTime());
    }

    public void reconnect() {
        this.reconnect(this.getCurOffset());
    }

    public void reconnect(String offset) {
        if (this.numRetries >= this.numMaxRetries) {
            throw new SamzaException(String.format("Give up reconnecting. numRetries: %d; numMaxRetries: %d", this.numRetries, this.numMaxRetries));
        }
        LOG.info(String.format("Reconnecting with offset: %s numRetries: %d numMaxRetries: %d", offset, this.numRetries, this.numMaxRetries));
        ++this.numRetries;
        this.init(offset);
    }

    public void close() {
        LOG.info(String.format("MiltiFileHdfsReader shutdown requested for %s. Current offset = %s", this.systemStreamPartition, this.getCurOffset()));
        if (this.curReader != null) {
            this.curReader.close();
        }
    }

    public SystemStreamPartition getSystemStreamPartition() {
        return this.systemStreamPartition;
    }
}

