/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.writer;

import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.samza.system.OutgoingMessageEnvelope;
import org.apache.samza.system.hdfs.HdfsConfig;
import org.apache.samza.system.hdfs.writer.Bucketer;
import org.apache.samza.system.hdfs.writer.Bucketer$;
import org.apache.samza.system.hdfs.writer.HdfsWriter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001=\u0011a#\u0011<s_\u0012\u000bG/\u0019$jY\u0016DEMZ:Xe&$XM\u001d\u0006\u0003\u0007\u0011\taa\u001e:ji\u0016\u0014(BA\u0003\u0007\u0003\u0011AGMZ:\u000b\u0005\u001dA\u0011AB:zgR,WN\u0003\u0002\n\u0015\u0005)1/Y7{C*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0007E\u0011B#D\u0001\u0003\u0013\t\u0019\"A\u0001\u0006II\u001a\u001cxK]5uKJ\u00042!\u0006\u000e\u001d\u001b\u00051\"BA\f\u0019\u0003\u00111\u0017\u000e\\3\u000b\u0005eQ\u0011\u0001B1we>L!a\u0007\f\u0003\u001d\u0011\u000bG/\u0019$jY\u0016<&/\u001b;feB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005Y\u0006twMC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"AB(cU\u0016\u001cG\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003\r!gm\u001d\t\u0003O1j\u0011\u0001\u000b\u0006\u0003S)\n!AZ:\u000b\u0005-R\u0011A\u00025bI>|\u0007/\u0003\u0002.Q\tQa)\u001b7f'f\u001cH/Z7\t\u0011=\u0002!\u0011!Q\u0001\nA\n!b]=ti\u0016lg*Y7f!\t\ttG\u0004\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u0011!Y\u0004A!A!\u0002\u0013a\u0014AB2p]\u001aLw\r\u0005\u0002>}5\tA!\u0003\u0002@\t\tQ\u0001\n\u001a4t\u0007>tg-[4\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\rqJg.\u001b;?)\u0011\u0019E)\u0012$\u0011\u0005E\u0001\u0001\"B\u0013A\u0001\u00041\u0003\"B\u0018A\u0001\u0004\u0001\u0004\"B\u001eA\u0001\u0004a\u0004b\u0002%\u0001\u0005\u0004%\t!S\u0001\nE\u0006$8\r[*ju\u0016,\u0012A\u0013\t\u0003e-K!\u0001T\u001a\u0003\t1{gn\u001a\u0005\u0007\u001d\u0002\u0001\u000b\u0011\u0002&\u0002\u0015\t\fGo\u00195TSj,\u0007\u0005C\u0004Q\u0001\t\u0007I\u0011A)\u0002\u0011\t,8m[3uKJ,\u0012A\u0015\t\u0004eM+\u0016B\u0001+4\u0005\u0011\u0019v.\\3\u0011\u0005E1\u0016BA,\u0003\u0005!\u0011UoY6fi\u0016\u0014\bBB-\u0001A\u0003%!+A\u0005ck\u000e\\W\r^3sA!91\f\u0001a\u0001\n\u0003I\u0015A\u0004:fG>\u0014Hm],sSR$XM\u001c\u0005\b;\u0002\u0001\r\u0011\"\u0001_\u0003I\u0011XmY8sIN<&/\u001b;uK:|F%Z9\u0015\u0005}\u0013\u0007C\u0001\u001aa\u0013\t\t7G\u0001\u0003V]&$\bbB2]\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\n\u0004BB3\u0001A\u0003&!*A\bsK\u000e|'\u000fZ:Xe&$H/\u001a8!\u0011\u00159\u0007\u0001\"\u0011i\u0003\u00151G.^:i+\u0005y\u0006\"\u00026\u0001\t\u0003Z\u0017!B<sSR,GCA0m\u0011\u0015i\u0017\u000e1\u0001o\u0003!yW\u000f^4pS:<\u0007CA8q\u001b\u00051\u0011BA9\u0007\u0005]yU\u000f^4pS:<W*Z:tC\u001e,WI\u001c<fY>\u0004X\rC\u0003t\u0001\u0011\u0005\u0003.A\u0003dY>\u001cX\rC\u0003v\u0001\u0011Ea/\u0001\rtQ>,H\u000eZ*uCJ$h*Z<PkR\u0004X\u000f\u001e$jY\u0016,\u0012a\u001e\t\u0003eaL!!_\u001a\u0003\u000f\t{w\u000e\\3b]\")1\u0010\u0001C\ty\u0006iq-\u001a;OKb$xK]5uKJ$2!`A\u0001!\r\u0011d\u0010F\u0005\u0003\u007fN\u0012aa\u00149uS>t\u0007BBA\u0002u\u0002\u0007A$\u0001\u0004sK\u000e|'\u000f\u001a")
public class AvroDataFileHdfsWriter
extends HdfsWriter<DataFileWriter<Object>> {
    private final FileSystem dfs;
    private final String systemName;
    private final HdfsConfig config;
    private final long batchSize;
    private final Some<Bucketer> bucketer;
    private long recordsWritten;

    public long batchSize() {
        return this.batchSize;
    }

    public Some<Bucketer> bucketer() {
        return this.bucketer;
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    public void recordsWritten_$eq(long x$1) {
        this.recordsWritten = x$1;
    }

    @Override
    public void flush() {
        this.writer().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DataFileWriter<Object> x$1) {
                x$1.flush();
            }
        });
    }

    @Override
    public void write(OutgoingMessageEnvelope outgoing) {
        Object record = outgoing.getMessage();
        if (this.shouldStartNewOutputFile()) {
            this.close();
            this.writer_$eq(this.getNextWriter(record));
        }
        this.writer().map((Function1)new Serializable(this, record){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AvroDataFileHdfsWriter $outer;
            private final Object record$1;

            public final void apply(DataFileWriter<Object> seq) {
                seq.append(this.record$1);
                this.$outer.recordsWritten_$eq(this.$outer.recordsWritten() + 1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.record$1 = record$1;
            }
        });
    }

    @Override
    public void close() {
        this.writer().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(DataFileWriter<Object> w) {
                w.flush();
                IOUtils.closeStream(w);
            }
        });
        this.writer_$eq(None$.MODULE$);
        this.recordsWritten_$eq(0L);
    }

    public boolean shouldStartNewOutputFile() {
        return this.recordsWritten() >= this.batchSize() || ((Bucketer)this.bucketer().get()).shouldChangeBucket();
    }

    public Option<DataFileWriter<Object>> getNextWriter(Object record) {
        Schema schema;
        Path path = ((Bucketer)this.bucketer().get()).getNextWritePath(this.dfs).suffix(".avro");
        boolean isGenericRecord = record instanceof GenericRecord;
        Object object = record;
        if (object instanceof GenericRecord) {
            GenericRecord genericRecord = (GenericRecord)object;
            schema = genericRecord.getSchema();
        } else {
            schema = ReflectData.get().getSchema(record.getClass());
        }
        Schema schema2 = schema;
        GenericDatumWriter datumWriter = isGenericRecord ? new GenericDatumWriter(schema2) : new ReflectDatumWriter(schema2);
        DataFileWriter fileWriter = new DataFileWriter((DatumWriter)datumWriter);
        String cn = this.config.getCompressionType(this.systemName);
        Object object2 = cn.equals("none") ? BoxedUnit.UNIT : fileWriter.setCodec(CodecFactory.fromString((String)cn));
        return new Some((Object)fileWriter.create(schema2, (OutputStream)this.dfs.create(path)));
    }

    public AvroDataFileHdfsWriter(FileSystem dfs, String systemName, HdfsConfig config) {
        this.dfs = dfs;
        this.systemName = systemName;
        this.config = config;
        super(dfs, systemName, config);
        this.batchSize = config.getWriteBatchSizeRecords(systemName);
        this.bucketer = new Some((Object)Bucketer$.MODULE$.getInstance(systemName, config));
        this.recordsWritten = 0L;
    }
}

