/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.system.hdfs.writer;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.samza.system.hdfs.HdfsConfig;
import org.apache.samza.system.hdfs.writer.Bucketer;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001f\t9\"j\u001c2OC6,G)\u0019;f)&lWMQ;dW\u0016$XM\u001d\u0006\u0003\u0007\u0011\taa\u001e:ji\u0016\u0014(BA\u0003\u0007\u0003\u0011AGMZ:\u000b\u0005\u001dA\u0011AB:zgR,WN\u0003\u0002\n\u0015\u0005)1/Y7{C*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\t\u0005V\u001c7.\u001a;fe\"A1\u0004\u0001B\u0001B\u0003%A$\u0001\u0006tsN$X-\u001c(b[\u0016\u0004\"!\b\u0011\u000f\u0005Eq\u0012BA\u0010\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011E\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}\u0011\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\r\r|gNZ5h!\t1s%D\u0001\u0005\u0013\tACA\u0001\u0006II\u001a\u001c8i\u001c8gS\u001eDQA\u000b\u0001\u0005\u0002-\na\u0001P5oSRtDc\u0001\u0017.]A\u0011q\u0003\u0001\u0005\u00067%\u0002\r\u0001\b\u0005\u0006I%\u0002\r!\n\u0005\ba\u0001\u0011\r\u0011\"\u00012\u0003!\u0011\u0017m]3QCRDW#\u0001\u000f\t\rM\u0002\u0001\u0015!\u0003\u001d\u0003%\u0011\u0017m]3QCRD\u0007\u0005C\u00046\u0001\t\u0007I\u0011\u0001\u001c\u0002\u001b\u0011\fG/\u001a$pe6\fG\u000f^3s+\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003\u0011!X\r\u001f;\u000b\u0003q\nAA[1wC&\u0011a(\u000f\u0002\u0011'&l\u0007\u000f\\3ECR,gi\u001c:nCRDa\u0001\u0011\u0001!\u0002\u00139\u0014A\u00043bi\u00164uN]7biR,'\u000f\t\u0005\b\u0005\u0002\u0011\r\u0011\"\u00012\u0003!1\u0017\u000e\\3CCN,\u0007B\u0002#\u0001A\u0003%A$A\u0005gS2,')Y:fA!9a\t\u0001a\u0001\n\u00039\u0015!\u00039beRLe\u000eZ3y+\u0005A\u0005CA\tJ\u0013\tQ%CA\u0002J]RDq\u0001\u0014\u0001A\u0002\u0013\u0005Q*A\u0007qCJ$\u0018J\u001c3fq~#S-\u001d\u000b\u0003\u001dF\u0003\"!E(\n\u0005A\u0013\"\u0001B+oSRDqAU&\u0002\u0002\u0003\u0007\u0001*A\u0002yIEBa\u0001\u0016\u0001!B\u0013A\u0015A\u00039beRLe\u000eZ3yA!9a\u000b\u0001a\u0001\n\u00039\u0016aD2veJ,g\u000e\u001e#bi\u0016$\u0016.\\3\u0016\u0003a\u0003\"!\u0017/\u000e\u0003iS!aW\u001e\u0002\t1\fgnZ\u0005\u0003CiCqA\u0018\u0001A\u0002\u0013\u0005q,A\ndkJ\u0014XM\u001c;ECR,G+[7f?\u0012*\u0017\u000f\u0006\u0002OA\"9!+XA\u0001\u0002\u0004A\u0006B\u00022\u0001A\u0003&\u0001,\u0001\tdkJ\u0014XM\u001c;ECR,G+[7fA!)A\r\u0001C!K\u0006\u00112\u000f[8vY\u0012\u001c\u0005.\u00198hK\n+8m[3u+\u00051\u0007CA\th\u0013\tA'CA\u0004C_>dW-\u00198\t\u000b)\u0004A\u0011I6\u0002!\u001d,GOT3yi^\u0013\u0018\u000e^3QCRDGC\u00017u!\ti'/D\u0001o\u0015\ty\u0007/\u0001\u0002gg*\u0011\u0011OC\u0001\u0007Q\u0006$wn\u001c9\n\u0005Mt'\u0001\u0002)bi\"DQ!^5A\u0002Y\f1\u0001\u001a4t!\tiw/\u0003\u0002y]\nQa)\u001b7f'f\u001cH/Z7\t\u000bi\u0004A\u0011C\u0019\u0002\u00199,\u0007\u0010\u001e)beR4\u0015\u000e\\3")
public class JobNameDateTimeBucketer
implements Bucketer {
    private final String basePath;
    private final SimpleDateFormat dateFormatter;
    private final String fileBase;
    private int partIndex;
    private String currentDateTime;

    public String basePath() {
        return this.basePath;
    }

    public SimpleDateFormat dateFormatter() {
        return this.dateFormatter;
    }

    public String fileBase() {
        return this.fileBase;
    }

    public int partIndex() {
        return this.partIndex;
    }

    public void partIndex_$eq(int x$1) {
        this.partIndex = x$1;
    }

    public String currentDateTime() {
        return this.currentDateTime;
    }

    public void currentDateTime_$eq(String x$1) {
        this.currentDateTime = x$1;
    }

    @Override
    public boolean shouldChangeBucket() {
        String string = this.currentDateTime();
        String string2 = this.dateFormatter().format(new Date());
        return string != null ? !string.equals(string2) : string2 != null;
    }

    @Override
    public Path getNextWritePath(FileSystem dfs) {
        Object object;
        String dateTime = this.dateFormatter().format(new Date());
        Path base = new Path(((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.basePath(), dateTime}))).mkString("/"));
        String string = dateTime;
        String string2 = this.currentDateTime();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            object = BoxedUnit.UNIT;
        } else {
            this.currentDateTime_$eq(dateTime);
            object = BoxesRunTime.boxToBoolean((boolean)FileSystem.mkdirs((FileSystem)dfs, (Path)base, (FsPermission)FsPermission.getDirDefault()));
        }
        return new Path(base, this.nextPartFile());
    }

    public String nextPartFile() {
        this.partIndex_$eq(this.partIndex() + 1);
        if (this.partIndex() > 99999) {
            this.partIndex_$eq(1);
        }
        return new StringBuilder().append((Object)this.fileBase()).append((Object)new StringOps(Predef$.MODULE$.augmentString("%05d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.partIndex())}))).toString();
    }

    public JobNameDateTimeBucketer(String systemName, HdfsConfig config) {
        this.basePath = config.getBaseOutputDir(systemName);
        this.dateFormatter = config.getDatePathFormatter(systemName);
        this.fileBase = config.getFileUniqifier(systemName);
        this.partIndex = 0;
        this.currentDateTime = "";
    }
}

