/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;
import org.apache.samza.storage.kv.RocksDbKeyValueReader;
import org.apache.samza.util.CommandLine;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbReadingTool
extends CommandLine {
    private ArgumentAcceptingOptionSpec<String> dbPathArgument = this.parser().accepts("db-path", "path of RocksDb location").withRequiredArg().ofType(String.class).describedAs("db-path");
    private ArgumentAcceptingOptionSpec<String> dbNameArgument = this.parser().accepts("db-name", "name of the db").withRequiredArg().ofType(String.class).describedAs("db-name");
    private ArgumentAcceptingOptionSpec<Long> longKeyArgu = this.parser().accepts("long-key", "a list of long keys. Sperated by ','.").withOptionalArg().ofType(Long.class).describedAs("long-key").withValuesSeparatedBy(',');
    private ArgumentAcceptingOptionSpec<String> stringKeyArgu = this.parser().accepts("string-key", "a list of string keys. Sperated by ','.").withOptionalArg().ofType(String.class).describedAs("string-key").withValuesSeparatedBy(',');
    private ArgumentAcceptingOptionSpec<Integer> integerKeyArgu = this.parser().accepts("integer-key", "a list of integer keys. Sperated by ','.").withOptionalArg().ofType(Integer.class).describedAs("integer-key").withValuesSeparatedBy(',');
    private String dbPath = "";
    private String dbName = "";
    private Object key = null;
    private Logger log = LoggerFactory.getLogger(RocksDbReadingTool.class);

    public MapConfig loadConfig(OptionSet options) {
        MapConfig config = super.loadConfig(options);
        if (options.has(this.dbNameArgument)) {
            this.dbName = (String)options.valueOf(this.dbNameArgument);
        } else {
            this.log.error("Please specify DB Name using --db-name");
            System.exit(-1);
        }
        if (options.has(this.dbPathArgument)) {
            this.dbPath = (String)options.valueOf(this.dbPathArgument);
        } else {
            this.log.error("Please specify DB path using --db-path");
            System.exit(-1);
        }
        this.log.debug("Will read the RocksDb store " + this.dbName + " in " + this.dbPath);
        int keyTypeOptions = 0;
        if (options.has(this.integerKeyArgu)) {
            this.key = options.valuesOf(this.integerKeyArgu);
            ++keyTypeOptions;
        }
        if (options.has(this.longKeyArgu)) {
            this.key = options.valuesOf(this.longKeyArgu);
            ++keyTypeOptions;
        }
        if (options.has(this.stringKeyArgu)) {
            this.key = options.valuesOf(this.stringKeyArgu);
            ++keyTypeOptions;
        }
        if (keyTypeOptions > 1) {
            this.log.error("Found more than 1 type of key. Please specify only one type of key to use.");
            System.exit(-1);
        }
        if (this.key == null) {
            this.log.error("Can not find the key. Please specify the type of key to use");
            System.exit(-1);
        }
        return config;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public String getDbName() {
        return this.dbName;
    }

    public List<Object> getKeys() {
        return (List)this.key;
    }

    public void outputResult(Object key, Object value) {
        System.out.println("key=" + key + ",value=" + value);
    }

    public static void main(String[] args) throws RocksDBException {
        RocksDbReadingTool tool = new RocksDbReadingTool();
        OptionSet options = tool.parser().parse(args);
        MapConfig config = tool.loadConfig(options);
        String path = tool.getDbPath();
        String dbName = tool.getDbName();
        RocksDbKeyValueReader kvReader = new RocksDbKeyValueReader(dbName, path, (Config)config);
        for (Object obj : tool.getKeys()) {
            Object result = kvReader.get(obj);
            tool.outputResult(obj, result);
        }
        kvReader.stop();
    }
}

