/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.SerializerConfig;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.serializers.Serde;
import org.apache.samza.serializers.SerdeFactory;
import org.apache.samza.storage.StorageEngineFactory;
import org.apache.samza.storage.kv.RocksDbOptionsHelper;
import org.apache.samza.util.ReflectionUtil;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDbKeyValueReader {
    private static final Logger log = LoggerFactory.getLogger(RocksDbKeyValueReader.class);
    private RocksDB db;
    private Serde<Object> keySerde;
    private Serde<Object> valueSerde;

    public RocksDbKeyValueReader(String storeName, String dbPath, Config config) {
        StorageConfig storageConfig = new StorageConfig(config);
        SerializerConfig serializerConfig = new SerializerConfig(config);
        this.keySerde = this.getSerdeFromName(storageConfig.getStorageKeySerde(storeName).orElse(null), serializerConfig);
        this.valueSerde = this.getSerdeFromName(storageConfig.getStorageMsgSerde(storeName).orElse(null), serializerConfig);
        Options options = RocksDbOptionsHelper.options(config, 1, new File(dbPath), StorageEngineFactory.StoreMode.ReadWrite);
        RocksDB.loadLibrary();
        try {
            this.db = RocksDB.openReadOnly((Options)options, (String)dbPath);
        }
        catch (RocksDBException e) {
            throw new SamzaException("can not open the rocksDb in " + dbPath, (Throwable)e);
        }
    }

    public Object get(Object key) {
        byte[] byteKey = this.keySerde.toBytes(key);
        byte[] result = null;
        try {
            result = this.db.get(byteKey);
        }
        catch (RocksDBException e) {
            log.error("can not get the value for key: " + key);
        }
        if (result == null) {
            log.info(key + " does not exist in the rocksDb");
            return null;
        }
        return this.valueSerde.fromBytes(result);
    }

    public void stop() {
        log.debug("closing the db");
        if (this.db != null) {
            this.db.close();
        }
        log.info("db is closed.");
    }

    private Serde<Object> getSerdeFromName(String name, SerializerConfig serializerConfig) {
        String serdeClassName = serializerConfig.getSerdeFactoryClass(name).orElseGet(() -> SerializerConfig.getPredefinedSerdeFactoryName((String)name));
        return ((SerdeFactory)ReflectionUtil.getObj((String)serdeClassName, SerdeFactory.class)).getSerde(name, (Config)serializerConfig);
    }
}

