/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv;

import java.io.File;
import org.apache.samza.config.Config;
import org.apache.samza.config.StorageConfig;
import org.apache.samza.context.ContainerContext;
import org.apache.samza.context.JobContext;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.serializers.Serde;
import org.apache.samza.storage.StorageEngine;
import org.apache.samza.storage.StorageEngineFactory;
import org.apache.samza.storage.kv.BaseKeyValueStorageEngineFactory;
import org.apache.samza.storage.kv.KeyValueStore;
import org.apache.samza.storage.kv.KeyValueStoreMetrics;
import org.apache.samza.storage.kv.RocksDbKeyValueStore;
import org.apache.samza.storage.kv.RocksDbOptionsHelper;
import org.apache.samza.system.SystemStreamPartition;
import org.apache.samza.task.MessageCollector;
import org.rocksdb.FlushOptions;
import org.rocksdb.Options;
import org.rocksdb.WriteOptions;
import scala.Function0;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001b\t\u0019#k\\2lg\u0012\u00137*Z=WC2,Xm\u0015;pe\u0006<W-\u00128hS:,g)Y2u_JL(BA\u0002\u0005\u0003\tYgO\u0003\u0002\u0006\r\u000591\u000f^8sC\u001e,'BA\u0004\t\u0003\u0015\u0019\u0018-\u001c>b\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001U\u0019a\"\b\u0016\u0014\u0007\u0001yq\u0003\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u0005!A.\u00198h\u0015\u0005!\u0012\u0001\u00026bm\u0006L!AF\t\u0003\r=\u0013'.Z2u!\u0011A\u0012dG\u0015\u000e\u0003\tI!A\u0007\u0002\u0003A\t\u000b7/Z&fsZ\u000bG.^3Ti>\u0014\u0018mZ3F]\u001eLg.\u001a$bGR|'/\u001f\t\u00039ua\u0001\u0001B\u0003\u001f\u0001\t\u0007qDA\u0001L#\t\u0001c\u0005\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0004O_RD\u0017N\\4\u0011\u0005\u0005:\u0013B\u0001\u0015#\u0005\r\te.\u001f\t\u00039)\"Qa\u000b\u0001C\u0002}\u0011\u0011A\u0016\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0002B\u0001\u0007\u0001\u001cS!)\u0011\u0007\u0001C!e\u0005Qq-\u001a;L-N#xN]3\u0015\u0011MbT)T+^K*\u0004B\u0001\u0007\u001b7m%\u0011QG\u0001\u0002\u000e\u0017\u0016Lh+\u00197vKN#xN]3\u0011\u0007\u0005:\u0014(\u0003\u00029E\t)\u0011I\u001d:bsB\u0011\u0011EO\u0005\u0003w\t\u0012AAQ=uK\")Q\b\ra\u0001}\u0005I1\u000f^8sK:\u000bW.\u001a\t\u0003\u007f\ts!!\t!\n\u0005\u0005\u0013\u0013A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011\u0012\t\u000b\u0019\u0003\u0004\u0019A$\u0002\u0011M$xN]3ESJ\u0004\"\u0001S&\u000e\u0003%S!AS\n\u0002\u0005%|\u0017B\u0001'J\u0005\u00111\u0015\u000e\\3\t\u000b9\u0003\u0004\u0019A(\u0002\u0011I,w-[:uef\u0004\"\u0001U*\u000e\u0003ES!A\u0015\u0004\u0002\u000f5,GO]5dg&\u0011A+\u0015\u0002\u0010\u001b\u0016$(/[2t%\u0016<\u0017n\u001d;ss\")a\u000b\ra\u0001/\u0006q2\r[1oO\u0016dunZ*zgR,Wn\u0015;sK\u0006l\u0007+\u0019:uSRLwN\u001c\t\u00031nk\u0011!\u0017\u0006\u00035\u001a\taa]=ti\u0016l\u0017B\u0001/Z\u0005U\u0019\u0016p\u001d;f[N#(/Z1n!\u0006\u0014H/\u001b;j_:DQA\u0018\u0019A\u0002}\u000b!B[8c\u0007>tG/\u001a=u!\t\u00017-D\u0001b\u0015\t\u0011g!A\u0004d_:$X\r\u001f;\n\u0005\u0011\f'A\u0003&pE\u000e{g\u000e^3yi\")a\r\ra\u0001O\u0006\u00012m\u001c8uC&tWM]\"p]R,\u0007\u0010\u001e\t\u0003A\"L!![1\u0003!\r{g\u000e^1j]\u0016\u00148i\u001c8uKb$\b\"B61\u0001\u0004a\u0017!C:u_J,Wj\u001c3f!\ti7P\u0004\u0002os:\u0011q\u000e\u001f\b\u0003a^t!!\u001d<\u000f\u0005I,X\"A:\u000b\u0005Qd\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003u\u0012\tAc\u0015;pe\u0006<W-\u00128hS:,g)Y2u_JL\u0018B\u0001?~\u0005%\u0019Fo\u001c:f\u001b>$WM\u0003\u0002{\t\u0001")
public class RocksDbKeyValueStorageEngineFactory<K, V>
implements BaseKeyValueStorageEngineFactory<K, V> {
    private final String org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY;

    public String org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY() {
        return this.org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY;
    }

    public void org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$_setter_$org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY_$eq(String x$1) {
        this.org$apache$samza$storage$kv$BaseKeyValueStorageEngineFactory$$INMEMORY_KV_STORAGE_ENGINE_FACTORY = x$1;
    }

    public StorageEngine getStorageEngine(String storeName, File storeDir, Serde<K> keySerde, Serde<V> msgSerde, MessageCollector changelogCollector, MetricsRegistry registry, SystemStreamPartition changelogSSP, JobContext jobContext, ContainerContext containerContext, StorageEngineFactory.StoreMode storeMode) {
        return BaseKeyValueStorageEngineFactory.class.getStorageEngine((BaseKeyValueStorageEngineFactory)this, (String)storeName, (File)storeDir, keySerde, msgSerde, (MessageCollector)changelogCollector, (MetricsRegistry)registry, (SystemStreamPartition)changelogSSP, (JobContext)jobContext, (ContainerContext)containerContext, (StorageEngineFactory.StoreMode)storeMode);
    }

    public <K, V> KeyValueStore<K, V> createCachedStore(String storeName, MetricsRegistry registry, KeyValueStore<K, V> underlyingStore, int cacheSize, int batchSize) {
        return BaseKeyValueStorageEngineFactory.class.createCachedStore((BaseKeyValueStorageEngineFactory)this, (String)storeName, (MetricsRegistry)registry, underlyingStore, (int)cacheSize, (int)batchSize);
    }

    public KeyValueStore<byte[], byte[]> getKVStore(String storeName, File storeDir, MetricsRegistry registry, SystemStreamPartition changeLogSystemStreamPartition, JobContext jobContext, ContainerContext containerContext, StorageEngineFactory.StoreMode storeMode) {
        Config storageConfigSubset = jobContext.getConfig().subset(new StringBuilder().append((Object)"stores.").append((Object)storeName).append((Object)".").toString(), true);
        boolean isLoggedStore = new StorageConfig(jobContext.getConfig()).getChangelogStream(storeName).isPresent();
        KeyValueStoreMetrics rocksDbMetrics = new KeyValueStoreMetrics(storeName, registry);
        int numTasksForContainer = containerContext.getContainerModel().getTasks().keySet().size();
        rocksDbMetrics.newGauge("rocksdb.block-cache-size", (Function0)new Serializable(this, storageConfigSubset, numTasksForContainer){
            public static final long serialVersionUID = 0L;
            private final Config storageConfigSubset$1;
            private final int numTasksForContainer$1;

            public final Long apply() {
                return RocksDbOptionsHelper.getBlockCacheSize(this.storageConfigSubset$1, this.numTasksForContainer$1);
            }
            {
                this.storageConfigSubset$1 = storageConfigSubset$1;
                this.numTasksForContainer$1 = numTasksForContainer$1;
            }
        });
        Options rocksDbOptions = RocksDbOptionsHelper.options(storageConfigSubset, numTasksForContainer, storeDir, storeMode);
        WriteOptions rocksDbWriteOptions = new WriteOptions().setDisableWAL(true);
        FlushOptions rocksDbFlushOptions = new FlushOptions().setWaitForFlush(true);
        RocksDbKeyValueStore rocksDb = new RocksDbKeyValueStore(storeDir, rocksDbOptions, storageConfigSubset, isLoggedStore, storeName, rocksDbWriteOptions, rocksDbFlushOptions, rocksDbMetrics);
        return rocksDb;
    }

    public RocksDbKeyValueStorageEngineFactory() {
        BaseKeyValueStorageEngineFactory.class.$init$((BaseKeyValueStorageEngineFactory)this);
    }
}

