/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.storage.kv.descriptors;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.samza.config.Config;
import org.apache.samza.serializers.KVSerde;
import org.apache.samza.storage.kv.LocalTableProviderFactory;
import org.apache.samza.storage.kv.RocksDbKeyValueStorageEngineFactory;
import org.apache.samza.table.descriptors.LocalTableDescriptor;

public class RocksDbTableDescriptor<K, V>
extends LocalTableDescriptor<K, V, RocksDbTableDescriptor<K, V>> {
    public static final String WRITE_BATCH_SIZE = "write.batch.size";
    public static final String OBJECT_CACHE_SIZE = "object.cache.size";
    public static final String CONTAINER_CACHE_SIZE_BYTES = "container.cache.size.bytes";
    public static final String CONTAINER_WRITE_BUFFER_SIZE_BYTES = "container.write.buffer.size.bytes";
    public static final String ROCKSDB_COMPRESSION = "rocksdb.compression";
    public static final String ROCKSDB_BLOCK_SIZE_BYTES = "rocksdb.block.size.bytes";
    public static final String ROCKSDB_TTL_MS = "rocksdb.ttl.ms";
    public static final String ROCKSDB_COMPACTION_STYLE = "rocksdb.compaction.style";
    public static final String ROCKSDB_NUM_WRITE_BUFFERS = "rocksdb.num.write.buffers";
    public static final String ROCKSDB_MAX_LOG_FILE_SIZE_BYTES = "rocksdb.max.log.file.size.bytes";
    public static final String ROCKSDB_KEEP_LOG_FILE_NUM = "rocksdb.keep.log.file.num";
    private Integer writeBatchSize;
    private Integer objectCacheSize;
    private Integer cacheSize;
    private Integer writeBufferSize;
    private Integer blockSize;
    private Long ttl;
    private Integer numWriteBuffers;
    private Integer maxLogFileSize;
    private Integer numLogFilesToKeep;
    private String compressionType;
    private String compactionStyle;

    public RocksDbTableDescriptor(String tableId, KVSerde<K, V> serde) {
        super(tableId, serde);
    }

    public RocksDbTableDescriptor withWriteBatchSize(int writeBatchSize) {
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public RocksDbTableDescriptor withObjectCacheSize(int objectCacheSize) {
        this.objectCacheSize = objectCacheSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withCompressionType(String compressionType) {
        this.compressionType = compressionType;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withBlockSize(int blockSize) {
        this.blockSize = blockSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withCompactionStyle(String compactionStyle) {
        this.compactionStyle = compactionStyle;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withNumWriteBuffers(int numWriteBuffers) {
        this.numWriteBuffers = numWriteBuffers;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withMaxLogFileSize(int maxLogFileSize) {
        this.maxLogFileSize = maxLogFileSize;
        return this;
    }

    public RocksDbTableDescriptor<K, V> withNumLogFilesToKeep(int numLogFilesToKeep) {
        this.numLogFilesToKeep = numLogFilesToKeep;
        return this;
    }

    public String getProviderFactoryClassName() {
        return LocalTableProviderFactory.class.getName();
    }

    public Map<String, String> toConfig(Config jobConfig) {
        HashMap<String, String> tableConfig = new HashMap<String, String>(super.toConfig(jobConfig));
        tableConfig.put(String.format("stores.%s.factory", this.tableId), RocksDbKeyValueStorageEngineFactory.class.getName());
        if (this.writeBatchSize != null) {
            this.addStoreConfig(WRITE_BATCH_SIZE, this.writeBatchSize.toString(), tableConfig);
        }
        if (this.objectCacheSize != null) {
            this.addStoreConfig(OBJECT_CACHE_SIZE, this.objectCacheSize.toString(), tableConfig);
        }
        if (this.cacheSize != null) {
            this.addStoreConfig(CONTAINER_CACHE_SIZE_BYTES, this.cacheSize.toString(), tableConfig);
        }
        if (this.writeBufferSize != null) {
            this.addStoreConfig(CONTAINER_WRITE_BUFFER_SIZE_BYTES, this.writeBufferSize.toString(), tableConfig);
        }
        if (this.compressionType != null) {
            this.addStoreConfig(ROCKSDB_COMPRESSION, this.compressionType, tableConfig);
        }
        if (this.blockSize != null) {
            this.addStoreConfig(ROCKSDB_BLOCK_SIZE_BYTES, this.blockSize.toString(), tableConfig);
        }
        if (this.ttl != null) {
            this.addStoreConfig(ROCKSDB_TTL_MS, this.ttl.toString(), tableConfig);
        }
        if (this.compactionStyle != null) {
            this.addStoreConfig(ROCKSDB_COMPACTION_STYLE, this.compactionStyle, tableConfig);
        }
        if (this.numWriteBuffers != null) {
            this.addStoreConfig(ROCKSDB_NUM_WRITE_BUFFERS, this.numWriteBuffers.toString(), tableConfig);
        }
        if (this.maxLogFileSize != null) {
            this.addStoreConfig(ROCKSDB_MAX_LOG_FILE_SIZE_BYTES, this.maxLogFileSize.toString(), tableConfig);
        }
        if (this.numLogFilesToKeep != null) {
            this.addStoreConfig(ROCKSDB_KEEP_LOG_FILE_NUM, this.numLogFilesToKeep.toString(), tableConfig);
        }
        return Collections.unmodifiableMap(tableConfig);
    }
}

