/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.MapConfig;

public class YarnConfig
extends MapConfig {
    public static final String PACKAGE_PATH = "yarn.package.path";
    public static final String YARN_APPLICATION_TYPE = "yarn.application.type";
    public static final String DEFAULT_SAMZA_APPLICATION_TYPE = "Samza";
    public static final String QUEUE_NAME = "yarn.queue";
    public static final String CONTAINER_LABEL = "yarn.container.label";
    public static final String AM_JVM_OPTIONS = "yarn.am.opts";
    public static final String AM_JMX_ENABLED = "yarn.am.jmx.enabled";
    public static final String AM_CONTAINER_MAX_MEMORY_MB = "yarn.am.container.memory.mb";
    private static final int DEFAULT_AM_CONTAINER_MAX_MEMORY_MB = 1024;
    public static final String AM_CONTAINER_LABEL = "yarn.am.container.label";
    public static final String AM_CONTAINER_MAX_CPU_CORES = "yarn.am.container.cpu.cores";
    private static final int DEFAULT_AM_CPU_CORES = 1;
    public static final String AM_POLL_INTERVAL_MS = "yarn.am.poll.interval.ms";
    private static final int DEFAULT_POLL_INTERVAL_MS = 1000;
    public static final String AM_JAVA_HOME = "yarn.am.java.home";
    public static final String ALLOCATOR_SLEEP_MS = "yarn.allocator.sleep.ms";
    private static final int DEFAULT_ALLOCATOR_SLEEP_MS = 3600;
    public static final String CONTAINER_REQUEST_TIMEOUT_MS = "yarn.container.request.timeout.ms";
    private static final int DEFAULT_CONTAINER_REQUEST_TIMEOUT_MS = 5000;
    public static final String YARN_KERBEROS_PRINCIPAL = "yarn.kerberos.principal";
    public static final String YARN_KERBEROS_KEYTAB = "yarn.kerberos.keytab";
    public static final String YARN_TOKEN_RENEWAL_INTERVAL_SECONDS = "yarn.token.renewal.interval.seconds";
    private static final long DEFAULT_YARN_TOKEN_RENEWAL_INTERVAL_SECONDS = 86400L;
    public static final String YARN_CREDENTIALS_FILE = "yarn.credentials.file";
    public static final String YARN_JOB_STAGING_DIRECTORY = "yarn.job.staging.directory";
    public static final String YARN_APPLICATION_VIEW_ACL = "yarn.job.view.acl";
    public static final String YARN_APPLICATION_MODIFY_ACL = "yarn.job.modify.acl";

    public YarnConfig(Config config) {
        super((Map)config);
    }

    public int getAMPollIntervalMs() {
        return this.getInt(AM_POLL_INTERVAL_MS, 1000);
    }

    public String getContainerLabel() {
        return this.get(CONTAINER_LABEL, null);
    }

    public boolean getJmxServerEnabled() {
        return this.getBoolean(AM_JMX_ENABLED, true);
    }

    public String getPackagePath() {
        String packagePath = this.get(PACKAGE_PATH);
        if (packagePath == null) {
            throw new SamzaException("No YARN package path defined in config.");
        }
        return packagePath;
    }

    public int getAMContainerMaxMemoryMb() {
        return this.getInt(AM_CONTAINER_MAX_MEMORY_MB, 1024);
    }

    public String getAMContainerLabel() {
        return this.get(AM_CONTAINER_LABEL, null);
    }

    public int getAMContainerMaxCpuCores() {
        return this.getInt(AM_CONTAINER_MAX_CPU_CORES, 1);
    }

    public String getAmOpts() {
        return this.get(AM_JVM_OPTIONS, "");
    }

    public String getQueueName() {
        return this.get(QUEUE_NAME, null);
    }

    public String getAMJavaHome() {
        return this.get(AM_JAVA_HOME, null);
    }

    public int getAllocatorSleepTime() {
        return this.getInt(ALLOCATOR_SLEEP_MS, 3600);
    }

    public int getContainerRequestTimeout() {
        return this.getInt(CONTAINER_REQUEST_TIMEOUT_MS, 5000);
    }

    public String getYarnKerberosPrincipal() {
        return this.get(YARN_KERBEROS_PRINCIPAL, null);
    }

    public String getYarnKerberosKeytab() {
        return this.get(YARN_KERBEROS_KEYTAB, null);
    }

    public long getYarnTokenRenewalIntervalSeconds() {
        return this.getLong(YARN_TOKEN_RENEWAL_INTERVAL_SECONDS, 86400L);
    }

    public String getYarnCredentialsFile() {
        return this.get(YARN_CREDENTIALS_FILE, null);
    }

    public String getYarnJobStagingDirectory() {
        return this.get(YARN_JOB_STAGING_DIRECTORY, null);
    }

    public String getYarnApplicationViewAcl() {
        return this.get(YARN_APPLICATION_VIEW_ACL, null);
    }

    public String getYarnApplicationModifyAcl() {
        return this.get(YARN_APPLICATION_MODIFY_ACL, null);
    }

    public String getYarnApplicationType() {
        return this.get(YARN_APPLICATION_TYPE, DEFAULT_SAMZA_APPLICATION_TYPE);
    }

    public Map<ApplicationAccessType, String> getYarnApplicationAcls() {
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>();
        String viewAcl = this.getYarnApplicationViewAcl();
        String modifyAcl = this.getYarnApplicationModifyAcl();
        if (viewAcl != null) {
            acls.put(ApplicationAccessType.VIEW_APP, viewAcl);
        }
        if (modifyAcl != null) {
            acls.put(ApplicationAccessType.MODIFY_APP, modifyAcl);
        }
        return acls;
    }
}

