/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.samza.config.Config;
import org.apache.samza.job.yarn.LocalizerResourceException;

public class LocalizerResourceConfig {
    private static final String RESOURCE_PREFIX = "yarn.resources.";
    private static final String PATH_SUFFIX = ".path";
    private static final String RESOURCE_PATH = "yarn.resources.%s.path";
    private static final String RESOURCE_LOCAL_NAME = "yarn.resources.%s.local.name";
    private static final String RESOURCE_LOCAL_TYPE = "yarn.resources.%s.local.type";
    private static final String RESOURCE_LOCAL_VISIBILITY = "yarn.resources.%s.local.visibility";
    private static final String DEFAULT_RESOURCE_LOCAL_TYPE = "FILE";
    private static final String DEFAULT_RESOURCE_LOCAL_VISIBILITY = "APPLICATION";
    private final Config config;

    public LocalizerResourceConfig(Config config) {
        if (null == config) {
            throw new IllegalArgumentException("config cannot be null");
        }
        this.config = config;
    }

    public List<String> getResourceNames() {
        Config subConfig = this.config.subset(RESOURCE_PREFIX, true);
        ArrayList<String> resourceNames = new ArrayList<String>();
        for (String key : subConfig.keySet()) {
            if (!key.endsWith(PATH_SUFFIX)) continue;
            resourceNames.add(key.substring(0, key.length() - PATH_SUFFIX.length()));
        }
        return resourceNames;
    }

    public Path getResourcePath(String resourceName) {
        String pathStr = (String)this.config.get((Object)String.format(RESOURCE_PATH, resourceName));
        if (StringUtils.isEmpty((String)pathStr)) {
            throw new LocalizerResourceException("resource path is required but not defined in config for resource " + resourceName);
        }
        return new Path(pathStr);
    }

    public LocalResourceType getResourceLocalType(String resourceName) {
        String typeStr = this.config.get(String.format(RESOURCE_LOCAL_TYPE, resourceName), DEFAULT_RESOURCE_LOCAL_TYPE);
        return LocalResourceType.valueOf((String)StringUtils.upperCase((String)typeStr));
    }

    public LocalResourceVisibility getResourceLocalVisibility(String resourceName) {
        String visibilityStr = this.config.get(String.format(RESOURCE_LOCAL_VISIBILITY, resourceName), DEFAULT_RESOURCE_LOCAL_VISIBILITY);
        return LocalResourceVisibility.valueOf((String)StringUtils.upperCase((String)visibilityStr));
    }

    public String getResourceLocalName(String resourceName) {
        String name = this.config.get(String.format(RESOURCE_LOCAL_NAME, resourceName), resourceName);
        return name;
    }
}

