/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.YarnConfig;
import org.apache.samza.container.SecurityManager;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u00015\u0011QdU1nu\u0006\f\u0005\u000f]'bgR,'oU3dkJLG/_'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\tA!_1s]*\u0011QAB\u0001\u0004U>\u0014'BA\u0004\t\u0003\u0015\u0019\u0018-\u001c>b\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\f\u001d!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u001b\u001b\u0005A\"BA\r\u0007\u0003%\u0019wN\u001c;bS:,'/\u0003\u0002\u001c1\ty1+Z2ve&$\u00180T1oC\u001e,'\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 \r\u0005!Q\u000f^5m\u0013\t\tcDA\u0004M_\u001e<\u0017N\\4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\naaY8oM&<\u0007CA\u0013(\u001b\u00051#BA\u0012\u0007\u0013\tAcE\u0001\u0004D_:4\u0017n\u001a\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005Q\u0001.\u00193p_B\u001cuN\u001c4\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013\u0001B2p]\u001aT!\u0001\r\u0005\u0002\r!\fGm\\8q\u0013\t\u0011TFA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006i\u0001!\t!N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007YB\u0014\b\u0005\u00028\u00015\t!\u0001C\u0003$g\u0001\u0007A\u0005C\u0003+g\u0001\u00071\u0006C\u0004<\u0001\t\u0007I\u0011\u0002\u001f\u0002%Q|7.\u001a8SK:,w/\u0012=fGV$xN]\u000b\u0002{A\u0011aHQ\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u000bG>t7-\u001e:sK:$(BA\u0010\u0013\u0013\t\u0019uH\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016Da!\u0012\u0001!\u0002\u0013i\u0014a\u0005;pW\u0016t'+\u001a8fo\u0016CXmY;u_J\u0004\u0003\"B$\u0001\t\u0003A\u0015!B:uCJ$H#A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u0002!I!U\u0001\u0010Y><\u0017N\u001c$s_6\\U-\u001f;bER!\u0011JU.^\u0011\u0015\u0019v\n1\u0001U\u0003%\u0001(/\u001b8dSB\fG\u000e\u0005\u0002V1:\u0011!JV\u0005\u0003/.\u000ba\u0001\u0015:fI\u00164\u0017BA-[\u0005\u0019\u0019FO]5oO*\u0011qk\u0013\u0005\u00069>\u0003\r\u0001V\u0001\u0007W\u0016LH/\u00192\t\u000by{\u0005\u0019\u0001+\u0002\u001f\r\u0014X\rZ3oi&\fGn\u001d$jY\u0016DQ\u0001\u0019\u0001\u0005\n\u0005\fQcZ3u\u001d\u0016<H)\u001a7fO\u0006$\u0018n\u001c8U_.,g\u000e\u0006\u0002c\u007fB\u0019!jY3\n\u0005\u0011\\%!B!se\u0006L\bG\u00014q!\r9GN\\\u0007\u0002Q*\u0011\u0011N[\u0001\u0006i>\\WM\u001c\u0006\u0003W>\n\u0001b]3dkJLG/_\u0005\u0003[\"\u0014Q\u0001V8lK:\u0004\"a\u001c9\r\u0001\u0011I\u0011\u000fAA\u0001\u0002\u0003\u0015\t\u0001\u001f\u0002\u0003\u007fAJ!a\u001d;\u0002'\u0005$G\rR3mK\u001e\fG/[8o)>\\WM\\:\n\u0005U4(A\u0003$jY\u0016\u001c\u0016p\u001d;f[*\u0011qoL\u0001\u0003MN\f\"!\u001f?\u0011\u0005)S\u0018BA>L\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AS?\n\u0005y\\%aA!os\"9\u0011\u0011A0A\u0002\u0005\r\u0011aC2sK\u0012,g\u000e^5bYN\u0004B!!\u0002\u0002\b5\t!.C\u0002\u0002\n)\u00141b\u0011:fI\u0016tG/[1mg\"9\u0011Q\u0002\u0001\u0005\n\u0005=\u0011aF<sSR,g*Z<EK2,w-\u0019;j_:$vn[3o)\u0015I\u0015\u0011CA\u000f\u0011!\t\u0019\"a\u0003A\u0002\u0005U\u0011aE2sK\u0012,g\u000e^5bYN4\u0015\u000e\\3QCRD\u0007\u0003BA\f\u00033i\u0011A^\u0005\u0004\u000371(\u0001\u0002)bi\"D\u0001\"!\u0001\u0002\f\u0001\u0007\u00111\u0001\u0005\u0007\u0003C\u0001A\u0011\u0001%\u0002\tM$x\u000e\u001d")
public class SamzaAppMasterSecurityManager
implements SecurityManager,
Logging {
    private final Config config;
    private final Configuration hadoopConf;
    private final ScheduledExecutorService tokenRenewExecutor;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SamzaAppMasterSecurityManager samzaAppMasterSecurityManager = this;
        synchronized (samzaAppMasterSecurityManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SamzaAppMasterSecurityManager samzaAppMasterSecurityManager = this;
        synchronized (samzaAppMasterSecurityManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    private ScheduledExecutorService tokenRenewExecutor() {
        return this.tokenRenewExecutor;
    }

    public void start() {
        YarnConfig yarnConfig = new YarnConfig(this.config);
        String principal = yarnConfig.getYarnKerberosPrincipal();
        String keytab = new Path(yarnConfig.getYarnKerberosKeytab()).getName();
        long renewalInterval = yarnConfig.getYarnTokenRenewalIntervalSeconds();
        String credentialsFile = yarnConfig.getYarnCredentialsFile();
        Runnable tokenRenewRunnable = new Runnable(this, principal, keytab, credentialsFile){
            private final /* synthetic */ SamzaAppMasterSecurityManager $outer;
            private final String principal$1;
            private final String keytab$1;
            private final String credentialsFile$1;

            public void run() {
                try {
                    this.$outer.org$apache$samza$job$yarn$SamzaAppMasterSecurityManager$$loginFromKeytab(this.principal$1, this.keytab$1, this.credentialsFile$1);
                }
                catch (Exception exception) {
                    this.$outer.warn((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Failed to renew token and write out new credentials";
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.principal$1 = principal$1;
                this.keytab$1 = keytab$1;
                this.credentialsFile$1 = credentialsFile$1;
            }
        };
        this.tokenRenewExecutor().scheduleAtFixedRate(tokenRenewRunnable, 0L, renewalInterval, TimeUnit.SECONDS);
    }

    public void org$apache$samza$job$yarn$SamzaAppMasterSecurityManager$$loginFromKeytab(String principal, String keytab, String credentialsFile) {
        this.info((Function0<Object>)new Serializable(this, principal){
            public static final long serialVersionUID = 0L;
            private final String principal$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logging to KDC using principal: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.principal$2}));
            }
            {
                this.principal$2 = principal$2;
            }
        });
        UserGroupInformation keytabUser = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
        Credentials credentials = keytabUser.getCredentials();
        keytabUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(this, credentials){
            private final /* synthetic */ SamzaAppMasterSecurityManager $outer;
            private final Credentials credentials$1;

            public Void run() {
                this.$outer.org$apache$samza$job$yarn$SamzaAppMasterSecurityManager$$getNewDelegationToken(this.credentials$1);
                return null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = credentials$1;
            }
        });
        UserGroupInformation.getCurrentUser().addCredentials(credentials);
        Path credentialsFilePath = new Path(credentialsFile);
        this.writeNewDelegationToken(credentialsFilePath, credentials);
    }

    public Token<?>[] org$apache$samza$job$yarn$SamzaAppMasterSecurityManager$$getNewDelegationToken(Credentials credentials) {
        FileSystem fs = FileSystem.get((Configuration)this.hadoopConf);
        String tokenRenewer = UserGroupInformation.getCurrentUser().getShortUserName();
        return fs.addDelegationTokens(tokenRenewer, credentials);
    }

    private void writeNewDelegationToken(Path credentialsFilePath, Credentials credentials) {
        FileSystem fs = FileSystem.get((Configuration)this.hadoopConf);
        if (fs.exists(credentialsFilePath)) {
            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting existing credentials file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{credentialsFilePath})));
            boolean success = fs.delete(credentialsFilePath, false);
            if (!success) {
                throw new SamzaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed deleting existing credentials file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{credentialsFilePath})));
            }
        }
        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing new delegation to the token file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{credentialsFilePath})));
        credentials.writeTokenStorageFile(credentialsFilePath, this.hadoopConf);
    }

    public void stop() {
        this.tokenRenewExecutor().shutdown();
    }

    public SamzaAppMasterSecurityManager(Config config, Configuration hadoopConf) {
        this.config = config;
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.tokenRenewExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Samza AMSecurityManager TokenRenewer Thread-%d").setDaemon(true).build());
    }
}

