/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInputStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.samza.config.Config;
import org.apache.samza.config.YarnConfig;
import org.apache.samza.container.SecurityManager;
import org.apache.samza.job.yarn.SamzaContainerSecurityManager$;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0001\u0002\u0001\u001b\ti2+Y7{C\u000e{g\u000e^1j]\u0016\u00148+Z2ve&$\u00180T1oC\u001e,'O\u0003\u0002\u0004\t\u0005!\u00110\u0019:o\u0015\t)a!A\u0002k_\nT!a\u0002\u0005\u0002\u000bM\fWN_1\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000f\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0004\u0002\u0013\r|g\u000e^1j]\u0016\u0014\u0018BA\u000e\u0019\u0005=\u0019VmY;sSRLX*\u00198bO\u0016\u0014\bCA\u000f!\u001b\u0005q\"BA\u0010\u0007\u0003\u0011)H/\u001b7\n\u0005\u0005r\"a\u0002'pO\u001eLgn\u001a\u0005\tG\u0001\u0011\t\u0011)A\u0005I\u000511m\u001c8gS\u001e\u0004\"!J\u0014\u000e\u0003\u0019R!a\t\u0004\n\u0005!2#AB\"p]\u001aLw\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u00031A\u0017\rZ8pa\u000e{gNZ5h!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003d_:4'B\u0001\u0019\t\u0003\u0019A\u0017\rZ8pa&\u0011!'\f\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bQ\u0002A\u0011A\u001b\u0002\rqJg.\u001b;?)\r1\u0004(\u000f\t\u0003o\u0001i\u0011A\u0001\u0005\u0006GM\u0002\r\u0001\n\u0005\u0006UM\u0002\ra\u000b\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0003UIe.\u001b;jC2$U\r\\1z\u0013:\u001cVmY8oIN,\u0012!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0002\u0001\u0006)1oY1mC&\u0011!i\u0010\u0002\u0004\u0013:$\bB\u0002#\u0001A\u0003%Q(\u0001\fJ]&$\u0018.\u00197EK2\f\u00170\u00138TK\u000e|g\u000eZ:!\u0011\u001d1\u0005A1A\u0005\n\u001d\u000b!\u0003^8lK:\u0014VM\\3x\u000bb,7-\u001e;peV\t\u0001\n\u0005\u0002J\u001b6\t!J\u0003\u0002L\u0019\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005}\u0011\u0012B\u0001(K\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-\u001a\u0005\u0007!\u0002\u0001\u000b\u0011\u0002%\u0002'Q|7.\u001a8SK:,w/\u0012=fGV$xN\u001d\u0011\t\u000fI\u0003\u0001\u0019!C\u0005'\u0006!B.Y:u%\u00164'/Z:i)&lWm\u001d;b[B,\u0012\u0001\u0016\t\u0003}UK!AV \u0003\t1{gn\u001a\u0005\b1\u0002\u0001\r\u0011\"\u0003Z\u0003aa\u0017m\u001d;SK\u001a\u0014Xm\u001d5US6,7\u000f^1na~#S-\u001d\u000b\u00035v\u0003\"AP.\n\u0005q{$\u0001B+oSRDqAX,\u0002\u0002\u0003\u0007A+A\u0002yIEBa\u0001\u0019\u0001!B\u0013!\u0016!\u00067bgR\u0014VM\u001a:fg\"$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\u0006E\u0002!\taY\u0001\u0006gR\f'\u000f\u001e\u000b\u00025\")Q\r\u0001C\u0005M\u00061r-\u001a;De\u0016$WM\u001c;jC2\u001chI]8n\u0011\u001235\u000bF\u0002h[R\u0004\"\u0001[6\u000e\u0003%T!A[\u0018\u0002\u0011M,7-\u001e:jifL!\u0001\\5\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\u0006]\u0012\u0004\ra\\\u0001\u0003MN\u0004\"\u0001\u001d:\u000e\u0003ET!A\\\u0018\n\u0005M\f(A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")Q\u000f\u001aa\u0001m\u0006IAo\\6f]B\u000bG\u000f\u001b\t\u0003a^L!\u0001_9\u0003\tA\u000bG\u000f\u001b\u0005\u0006u\u0002!\taY\u0001\u0005gR|\u0007\u000f")
public class SamzaContainerSecurityManager
implements SecurityManager,
Logging {
    private final Config config;
    public final Configuration org$apache$samza$job$yarn$SamzaContainerSecurityManager$$hadoopConfig;
    private final int org$apache$samza$job$yarn$SamzaContainerSecurityManager$$InitialDelayInSeconds;
    private final ScheduledExecutorService org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor;
    private long org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SamzaContainerSecurityManager samzaContainerSecurityManager = this;
        synchronized (samzaContainerSecurityManager) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SamzaContainerSecurityManager samzaContainerSecurityManager = this;
        synchronized (samzaContainerSecurityManager) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public int org$apache$samza$job$yarn$SamzaContainerSecurityManager$$InitialDelayInSeconds() {
        return this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$InitialDelayInSeconds;
    }

    public ScheduledExecutorService org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor() {
        return this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor;
    }

    public long org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp() {
        return this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp;
    }

    public void org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp_$eq(long x$1) {
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp = x$1;
    }

    public void start() {
        YarnConfig yarnConfig = new YarnConfig(this.config);
        long renewalInterval = yarnConfig.getYarnTokenRenewalIntervalSeconds();
        Path tokenFilePath = new Path(yarnConfig.getYarnCredentialsFile());
        Runnable tokenRenewRunnable = new Runnable(this, renewalInterval, tokenFilePath){
            private final /* synthetic */ SamzaContainerSecurityManager $outer;
            public final long renewalInterval$1;
            private final Path tokenFilePath$1;

            public void run() {
                try {
                    FileSystem fs = FileSystem.get((Configuration)this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$hadoopConfig);
                    if (fs.exists(this.tokenFilePath$1)) {
                        FileStatus fileStatus = fs.getFileStatus(this.tokenFilePath$1);
                        if (this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp() > fileStatus.getModificationTime()) {
                            this.$outer.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Expecting to update delegation tokens, but AM has not updated credentials file yet, will retry in 5 minutes";
                                }
                            });
                            this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, 5L, TimeUnit.MINUTES);
                        } else {
                            Credentials credentials = this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$getCredentialsFromHDFS(fs, this.tokenFilePath$1);
                            UserGroupInformation.getCurrentUser().addCredentials(credentials);
                            this.$outer.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Successfully renewed tokens from credentials file";
                                }
                            });
                            this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp_$eq(System.currentTimeMillis());
                            this.$outer.info((Function0<Object>)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$1 $outer;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schedule the next fetch in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.renewalInterval$1)}));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                            this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, this.renewalInterval$1, TimeUnit.SECONDS);
                        }
                    } else {
                        this.$outer.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Credentials file not found yet. Schedule the next fetch in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.renewalInterval$1)}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, this.renewalInterval$1, TimeUnit.SECONDS);
                    }
                }
                catch (Exception exception) {
                    long retrySeconds = Math.min(this.renewalInterval$1, 3600L);
                    this.$outer.warn((Function0<Object>)new Serializable(this, retrySeconds){
                        public static final long serialVersionUID = 0L;
                        private final long retrySeconds$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to renew tokens, will retry in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.retrySeconds$1)}));
                        }
                        {
                            this.retrySeconds$1 = retrySeconds$1;
                        }
                    }, (Function0<Throwable>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                    this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(this, retrySeconds, TimeUnit.SECONDS);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.renewalInterval$1 = renewalInterval$1;
                this.tokenFilePath$1 = tokenFilePath$1;
            }
        };
        this.info((Function0<Object>)new Serializable(this, renewalInterval){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SamzaContainerSecurityManager $outer;
            private final long renewalInterval$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schedule the next fetch in ", " seconds"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.renewalInterval$1 + (long)this.$outer.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$InitialDelayInSeconds()))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.renewalInterval$1 = renewalInterval$1;
            }
        });
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().schedule(tokenRenewRunnable, renewalInterval + (long)this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$InitialDelayInSeconds(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public Credentials org$apache$samza$job$yarn$SamzaContainerSecurityManager$$getCredentialsFromHDFS(FileSystem fs, Path tokenPath) {
        Credentials credentials;
        FSDataInputStream stream = fs.open(tokenPath);
        try {
            Credentials newCredentials = new Credentials();
            newCredentials.readTokenStorageStream((DataInputStream)stream);
            credentials = newCredentials;
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        stream.close();
        return credentials;
    }

    public void stop() {
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor().shutdown();
    }

    public SamzaContainerSecurityManager(Config config, Configuration hadoopConfig) {
        this.config = config;
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$hadoopConfig = hadoopConfig;
        Logging.class.$init$((Logging)this);
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$InitialDelayInSeconds = 60;
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$tokenRenewExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("Samza ContainerSecurityManager TokenRenewer Thread-%d").setDaemon(true).build());
        this.org$apache$samza$job$yarn$SamzaContainerSecurityManager$$lastRefreshTimestamp = 0L;
    }
}

