/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.samza.SamzaException;
import org.apache.samza.clustermanager.SamzaApplicationState;
import org.apache.samza.clustermanager.SamzaResource;
import org.apache.samza.job.yarn.SamzaYarnAppMasterService;
import org.apache.samza.job.yarn.YarnAppState;
import org.apache.samza.job.yarn.YarnContainer;
import org.apache.samza.util.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d\u0001B\u0001\u0003\u00015\u00111dU1nu\u0006L\u0016M\u001d8BaBl\u0015m\u001d;fe2Kg-Z2zG2,'BA\u0002\u0005\u0003\u0011I\u0018M\u001d8\u000b\u0005\u00151\u0011a\u00016pE*\u0011q\u0001C\u0001\u0006g\u0006l'0\u0019\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/\u0019\tA!\u001e;jY&\u0011\u0011D\u0006\u0002\b\u0019><w-\u001b8h\u0011!Y\u0002A!A!\u0002\u0013a\u0012\u0001D2p]R\f\u0017N\\3s\u001b\u0016l\u0007CA\b\u001e\u0013\tq\u0002CA\u0002J]RD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rG>tG/Y5oKJ\u001c\u0005/\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u0005i1/Y7{C\u0006\u0003\bo\u0015;bi\u0016\u0004\"\u0001J\u0014\u000e\u0003\u0015R!A\n\u0004\u0002\u001d\rdWo\u001d;fe6\fg.Y4fe&\u0011\u0001&\n\u0002\u0016'\u0006l'0Y!qa2L7-\u0019;j_:\u001cF/\u0019;f\u0011!Q\u0003A!A!\u0002\u0013Y\u0013!B:uCR,\u0007C\u0001\u0017.\u001b\u0005\u0011\u0011B\u0001\u0018\u0003\u00051I\u0016M\u001d8BaB\u001cF/\u0019;f\u0011!\u0001\u0004A!A!\u0002\u0013\t\u0014\u0001C1n\u00072LWM\u001c;\u0011\u0007Ibd(D\u00014\u0015\t!T'A\u0003bgft7M\u0003\u00027o\u0005\u0019\u0011\r]5\u000b\u0005aJ\u0014AB2mS\u0016tGO\u0003\u0002\u0004u)\u00111\bC\u0001\u0007Q\u0006$wn\u001c9\n\u0005u\u001a$aD!N%6\u001bE.[3oi\u0006\u001b\u0018P\\2\u0011\u0005}\nfB\u0001!P\u001d\t\teJ\u0004\u0002C\u001b:\u00111\t\u0014\b\u0003\t.s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!c\u0011A\u0002\u001fs_>$h(C\u0001\f\u0013\tI!\"\u0003\u0002<\u0011%\u00111AO\u0005\u0003qeJ!AN\u001c\n\u0005A+\u0014AC!N%6\u001bE.[3oi&\u0011!k\u0015\u0002\u0011\u0007>tG/Y5oKJ\u0014V-];fgRT!\u0001U\u001b\t\u0011U\u0003!\u0011!Q\u0001\nY\u000b!&[:BaBd\u0017nY1uS>tW*Y:uKJD\u0015n\u001a5Bm\u0006LG.\u00192jY&$\u00180\u00128bE2,G\r\u0005\u0002\u0010/&\u0011\u0001\f\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015Q\u0006\u0001\"\u0001\\\u0003\u0019a\u0014N\\5u}Q9A,\u00180`A\u0006\u0014\u0007C\u0001\u0017\u0001\u0011\u0015Y\u0012\f1\u0001\u001d\u0011\u0015\u0001\u0013\f1\u0001\u001d\u0011\u0015\u0011\u0013\f1\u0001$\u0011\u0015Q\u0013\f1\u0001,\u0011\u0015\u0001\u0014\f1\u00012\u0011\u0015)\u0016\f1\u0001W\u0011\u001d!\u0007\u00011A\u0005\u0002\u0015\fAC^1mS\u0012\u0014Vm]8ve\u000e,'+Z9vKN$X#\u0001,\t\u000f\u001d\u0004\u0001\u0019!C\u0001Q\u0006Ab/\u00197jIJ+7o\\;sG\u0016\u0014V-];fgR|F%Z9\u0015\u0005%d\u0007CA\bk\u0013\tY\u0007C\u0001\u0003V]&$\bbB7g\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0004BB8\u0001A\u0003&a+A\u000bwC2LGMU3t_V\u00148-\u001a*fcV,7\u000f\u001e\u0011\t\u000fE\u0004\u0001\u0019!C\u0001e\u0006y1\u000f[;uI><h.T3tg\u0006<W-F\u0001t!\t!xO\u0004\u0002\u0010k&\u0011a\u000fE\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002w!!91\u0010\u0001a\u0001\n\u0003a\u0018aE:ikR$wn\u001e8NKN\u001c\u0018mZ3`I\u0015\fHCA5~\u0011\u001di'0!AA\u0002MDaa \u0001!B\u0013\u0019\u0018\u0001E:ikR$wn\u001e8NKN\u001c\u0018mZ3!\u0011%\t\u0019\u0001\u0001a\u0001\n\u0003\t)!\u0001\u0004xK\n\f\u0005\u000f]\u000b\u0003\u0003\u000f\u00012\u0001LA\u0005\u0013\r\tYA\u0001\u0002\u001a'\u0006l'0Y-be:\f\u0005\u000f]'bgR,'oU3sm&\u001cW\rC\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0002\u0012\u0005Qq/\u001a2BaB|F%Z9\u0015\u0007%\f\u0019\u0002C\u0005n\u0003\u001b\t\t\u00111\u0001\u0002\b!A\u0011q\u0003\u0001!B\u0013\t9!A\u0004xK\n\f\u0005\u000f\u001d\u0011\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u00051qN\\%oSR$\"!a\b\u0011\r\u0005\u0005\u0012\u0011FA\u0017\u001b\t\t\u0019CC\u0002\u0018\u0003KQ!!a\n\u0002\t)\fg/Y\u0005\u0005\u0003W\t\u0019CA\u0002TKR\u0004B!a\f\u000285\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$A\u0004sK\u000e|'\u000fZ:\u000b\u0005YJ\u0014\u0002BA\u001d\u0003c\u00111bQ8oi\u0006Lg.\u001a:JI\"9\u0011Q\b\u0001\u0005\u0002\u0005}\u0012\u0001C8o%\u0016\u0014wn\u001c;\u0015\u0003%Dq!a\u0011\u0001\t\u0003\t)%\u0001\u0006p]NCW\u000f\u001e3po:$2![A$\u0011!\tI%!\u0011A\u0002\u0005-\u0013AD:b[j\f\u0017\t\u001d9Ti\u0006$Xo\u001d\t\u0005\u0003\u001b\n\u0019FD\u0002%\u0003\u001fJ1!!\u0015&\u0003U\u0019\u0016-\u001c>b\u0003B\u0004H.[2bi&|gn\u0015;bi\u0016LA!!\u0016\u0002X\tq1+Y7{C\u0006\u0003\bo\u0015;biV\u001c(bAA)K!9\u00111\f\u0001\u0005\u0002\u0005u\u0013!C4fiN#\u0018\r^;t)\u0011\ty&!\u001a\u0011\t\u0005=\u0012\u0011M\u0005\u0005\u0003G\n\tD\u0001\fGS:\fG.\u00119qY&\u001c\u0017\r^5p]N#\u0018\r^;t\u0011!\tI%!\u0017A\u0002\u0005-\u0003BBA5\u0001\u0011\u0005Q-\u0001\btQ>,H\u000eZ*ikR$wn\u001e8")
public class SamzaYarnAppMasterLifecycle
implements Logging {
    private final int containerMem;
    private final int containerCpu;
    public final SamzaApplicationState org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$samzaAppState;
    public final YarnAppState org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$state;
    private final AMRMClientAsync<AMRMClient.ContainerRequest> amClient;
    private final boolean isApplicationMasterHighAvailabilityEnabled;
    private boolean validResourceRequest;
    private String shutdownMessage;
    private SamzaYarnAppMasterService webApp;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SamzaYarnAppMasterLifecycle samzaYarnAppMasterLifecycle = this;
        synchronized (samzaYarnAppMasterLifecycle) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        SamzaYarnAppMasterLifecycle samzaYarnAppMasterLifecycle = this;
        synchronized (samzaYarnAppMasterLifecycle) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public boolean validResourceRequest() {
        return this.validResourceRequest;
    }

    public void validResourceRequest_$eq(boolean x$1) {
        this.validResourceRequest = x$1;
    }

    public String shutdownMessage() {
        return this.shutdownMessage;
    }

    public void shutdownMessage_$eq(String x$1) {
        this.shutdownMessage = x$1;
    }

    public SamzaYarnAppMasterService webApp() {
        return this.webApp;
    }

    public void webApp_$eq(SamzaYarnAppMasterService x$1) {
        this.webApp = x$1;
    }

    public Set<ContainerId> onInit() {
        String host = this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$state.nodeHost;
        RegisterApplicationMasterResponse response = this.amClient.registerApplicationMaster(host, this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$state.rpcUrl.getPort(), new StringOps(Predef$.MODULE$.augmentString("%s:%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToInteger((int)this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$state.trackingUrl.getPort())})));
        Resource maxCapability = response.getMaximumResourceCapability();
        int maxMem = maxCapability.getMemory();
        int maxCpu = maxCapability.getVirtualCores();
        HashSet<ContainerId> previousAttemptContainers = new HashSet<ContainerId>();
        if (this.isApplicationMasterHighAvailabilityEnabled) {
            HashMap yarnIdToprocIdMap = new HashMap();
            ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$samzaAppState.processorToExecutionId).asScala()).foreach((Function1)new Serializable(this, yarnIdToprocIdMap){
                public static final long serialVersionUID = 0L;
                private final HashMap yarnIdToprocIdMap$1;

                public final String apply(Tuple2<String, String> entry) {
                    return (String)this.yarnIdToprocIdMap$1.put(entry._2(), entry._1());
                }
                {
                    this.yarnIdToprocIdMap$1 = yarnIdToprocIdMap$1;
                }
            });
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(response.getContainersFromPreviousAttempts()).asScala()).foreach((Function1)new Serializable(this, previousAttemptContainers, yarnIdToprocIdMap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SamzaYarnAppMasterLifecycle $outer;
                private final HashSet previousAttemptContainers$1;
                private final HashMap yarnIdToprocIdMap$1;

                public final boolean apply(Container ctr) {
                    String samzaProcId = (String)this.yarnIdToprocIdMap$1.get(ctr.getId().toString());
                    this.$outer.info((Function0<Object>)new Serializable(this, samzaProcId, ctr){
                        public static final long serialVersionUID = 0L;
                        private final String samzaProcId$1;
                        private final Container ctr$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Received container from previous attempt with samza processor id %s and yarn container id %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.samzaProcId$1, this.ctr$1.getId().toString()}));
                        }
                        {
                            this.samzaProcId$1 = samzaProcId$1;
                            this.ctr$1 = ctr$1;
                        }
                    });
                    this.$outer.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$samzaAppState.pendingProcessors.put(samzaProcId, new SamzaResource(ctr.getResource().getVirtualCores(), ctr.getResource().getMemory(), ctr.getNodeId().getHost(), ctr.getId().toString()));
                    this.$outer.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$state.pendingProcessors.put(samzaProcId, new YarnContainer(ctr));
                    return this.previousAttemptContainers$1.add(ctr.getId());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.previousAttemptContainers$1 = previousAttemptContainers$1;
                    this.yarnIdToprocIdMap$1 = yarnIdToprocIdMap$1;
                }
            });
        }
        this.info((Function0<Object>)new Serializable(this, maxMem, maxCpu){
            public static final long serialVersionUID = 0L;
            private final int maxMem$1;
            private final int maxCpu$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Got AM register response. The YARN RM supports container requests with max-mem: %s, max-cpu: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxMem$1), BoxesRunTime.boxToInteger((int)this.maxCpu$1)}));
            }
            {
                this.maxMem$1 = maxMem$1;
                this.maxCpu$1 = maxCpu$1;
            }
        });
        if (this.containerMem > maxMem || this.containerCpu > maxCpu) {
            this.shutdownMessage_$eq(new StringOps(Predef$.MODULE$.augmentString("The YARN cluster is unable to run your job due to unsatisfiable resource requirements. You asked for mem: %s, and cpu: %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.containerMem), BoxesRunTime.boxToInteger((int)this.containerCpu)})));
            this.error((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SamzaYarnAppMasterLifecycle $outer;

                public final String apply() {
                    return this.$outer.shutdownMessage();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.validResourceRequest_$eq(false);
            this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$samzaAppState.status = SamzaApplicationState.SamzaAppStatus.FAILED;
            this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$samzaAppState.jobHealthy.set(false);
        }
        return previousAttemptContainers;
    }

    public void onReboot() {
        throw new SamzaException("Received a reboot signal from the RM, so throwing an exception to reboot the AM.");
    }

    public void onShutdown(SamzaApplicationState.SamzaAppStatus samzaAppStatus) {
        Throwable throwable2;
        block5: {
            FinalApplicationStatus yarnStatus = this.getStatus(samzaAppStatus);
            this.info((Function0<Object>)new Serializable(this, samzaAppStatus, yarnStatus){
                public static final long serialVersionUID = 0L;
                private final SamzaApplicationState.SamzaAppStatus samzaAppStatus$1;
                private final FinalApplicationStatus yarnStatus$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Shutting down SamzaAppStatus: ").append((Object)this.samzaAppStatus$1).append((Object)" yarn status: ").append((Object)this.yarnStatus$1).toString();
                }
                {
                    this.samzaAppStatus$1 = samzaAppStatus$1;
                    this.yarnStatus$1 = yarnStatus$1;
                }
            });
            SamzaApplicationState.SamzaAppStatus samzaAppStatus2 = samzaAppStatus;
            SamzaApplicationState.SamzaAppStatus samzaAppStatus3 = SamzaApplicationState.SamzaAppStatus.UNDEFINED;
            if (!(samzaAppStatus2 != null ? !samzaAppStatus2.equals(samzaAppStatus3) : samzaAppStatus3 != null)) {
                this.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Not unregistering AM from the RM. This will enable RM retries";
                    }
                });
            } else {
                this.info((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Unregistering AM from the RM.";
                    }
                });
                try {
                    this.amClient.unregisterApplicationMaster(yarnStatus, this.shutdownMessage(), null);
                    this.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Unregister complete.";
                        }
                    });
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    if (throwable3 instanceof InvalidApplicationMasterRequestException) {
                        this.info((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Removed application attempt from RM cache because the AM died. Unregister complete.";
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    boolean bl = throwable3 instanceof YarnException ? true : throwable3 instanceof IOException;
                    if (!bl) break block5;
                    this.error((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Caught an exception while trying to unregister AM. Trying to stop other components.";
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable3){
                        public static final long serialVersionUID = 0L;
                        private final Throwable x7$1;

                        public final Throwable apply() {
                            return this.x7$1;
                        }
                        {
                            this.x7$1 = x7$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            return;
        }
        throw throwable2;
    }

    public FinalApplicationStatus getStatus(SamzaApplicationState.SamzaAppStatus samzaAppStatus) {
        SamzaApplicationState.SamzaAppStatus samzaAppStatus2 = samzaAppStatus;
        SamzaApplicationState.SamzaAppStatus samzaAppStatus3 = SamzaApplicationState.SamzaAppStatus.FAILED;
        if (!(samzaAppStatus2 != null ? !samzaAppStatus2.equals(samzaAppStatus3) : samzaAppStatus3 != null)) {
            return FinalApplicationStatus.FAILED;
        }
        SamzaApplicationState.SamzaAppStatus samzaAppStatus4 = samzaAppStatus;
        SamzaApplicationState.SamzaAppStatus samzaAppStatus5 = SamzaApplicationState.SamzaAppStatus.SUCCEEDED;
        if (!(samzaAppStatus4 != null ? !samzaAppStatus4.equals(samzaAppStatus5) : samzaAppStatus5 != null)) {
            return FinalApplicationStatus.SUCCEEDED;
        }
        return FinalApplicationStatus.UNDEFINED;
    }

    public boolean shouldShutdown() {
        return !this.validResourceRequest();
    }

    public SamzaYarnAppMasterLifecycle(int containerMem, int containerCpu, SamzaApplicationState samzaAppState, YarnAppState state, AMRMClientAsync<AMRMClient.ContainerRequest> amClient, boolean isApplicationMasterHighAvailabilityEnabled) {
        this.containerMem = containerMem;
        this.containerCpu = containerCpu;
        this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$samzaAppState = samzaAppState;
        this.org$apache$samza$job$yarn$SamzaYarnAppMasterLifecycle$$state = state;
        this.amClient = amClient;
        this.isApplicationMasterHighAvailabilityEnabled = isApplicationMasterHighAvailabilityEnabled;
        Logging.class.$init$((Logging)this);
        this.validResourceRequest = true;
        this.shutdownMessage = null;
        this.webApp = null;
    }
}

