/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.client.api.impl.YarnClientImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.samza.SamzaException;
import org.apache.samza.clustermanager.FaultDomain;
import org.apache.samza.clustermanager.FaultDomainManager;
import org.apache.samza.clustermanager.FaultDomainType;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.MetricsRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnFaultDomainManager
implements FaultDomainManager {
    private static final Logger log = LoggerFactory.getLogger(FaultDomainManager.class);
    private static final String FAULT_DOMAIN_MANAGER_GROUP = "yarn-fault-domain-manager";
    private static final String HOST_TO_FAULT_DOMAIN_CACHE_UPDATES = "host-to-fault-domain-cache-updates";
    private Multimap<String, FaultDomain> hostToRackMap;
    private final YarnClientImpl yarnClient;
    private Counter hostToFaultDomainCacheUpdates;

    public YarnFaultDomainManager(MetricsRegistry metricsRegistry) {
        this.yarnClient = new YarnClientImpl();
        this.yarnClient.init((Configuration)new YarnConfiguration());
        this.yarnClient.start();
        this.hostToRackMap = this.computeHostToFaultDomainMap();
        this.hostToFaultDomainCacheUpdates = metricsRegistry.newCounter(FAULT_DOMAIN_MANAGER_GROUP, HOST_TO_FAULT_DOMAIN_CACHE_UPDATES);
    }

    @VisibleForTesting
    YarnFaultDomainManager(MetricsRegistry metricsRegistry, YarnClientImpl yarnClient, Multimap<String, FaultDomain> hostToRackMap) {
        this.yarnClient = yarnClient;
        yarnClient.init((Configuration)new YarnConfiguration());
        yarnClient.start();
        this.hostToRackMap = hostToRackMap;
        this.hostToFaultDomainCacheUpdates = metricsRegistry.newCounter(FAULT_DOMAIN_MANAGER_GROUP, HOST_TO_FAULT_DOMAIN_CACHE_UPDATES);
    }

    public Set<FaultDomain> getAllFaultDomains() {
        return new HashSet<FaultDomain>(this.hostToRackMap.values());
    }

    public Set<FaultDomain> getFaultDomainsForHost(String host) {
        if (!this.hostToRackMap.containsKey((Object)host)) {
            this.hostToRackMap = this.computeHostToFaultDomainMap();
            this.hostToFaultDomainCacheUpdates.inc();
        }
        return new HashSet<FaultDomain>(this.hostToRackMap.get((Object)host));
    }

    public boolean hasSameFaultDomains(String host1, String host2) {
        if (!this.hostToRackMap.keySet().contains(host1) || !this.hostToRackMap.keySet().contains(host2)) {
            this.hostToRackMap = this.computeHostToFaultDomainMap();
            this.hostToFaultDomainCacheUpdates.inc();
        }
        return this.hostToRackMap.get((Object)host1).equals(this.hostToRackMap.get((Object)host2));
    }

    @VisibleForTesting
    Multimap<String, FaultDomain> computeHostToFaultDomainMap() {
        HashMultimap hostToRackMap = HashMultimap.create();
        try {
            List nodeReport = this.yarnClient.getNodeReports(new NodeState[]{NodeState.RUNNING});
            nodeReport.forEach(arg_0 -> YarnFaultDomainManager.lambda$computeHostToFaultDomainMap$0((Multimap)hostToRackMap, arg_0));
            log.info("Computed the host to rack map successfully from Yarn.");
        }
        catch (IOException | YarnException e) {
            throw new SamzaException("Yarn threw an exception while getting NodeReports.", e);
        }
        return hostToRackMap;
    }

    private static /* synthetic */ void lambda$computeHostToFaultDomainMap$0(Multimap hostToRackMap, NodeReport report) {
        FaultDomain rack = new FaultDomain(FaultDomainType.RACK, report.getRackName());
        hostToRackMap.put((Object)report.getNodeId().getHost(), (Object)rack);
    }
}

