/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.job.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.config.YarnConfig;
import org.apache.samza.job.ApplicationStatus;
import org.apache.samza.job.StreamJob;
import org.apache.samza.job.yarn.ClientHelper;
import org.apache.samza.job.yarn.YarnJob$;
import org.apache.samza.util.Logging;
import org.apache.samza.util.ScalaJavaUtil;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001B\u0001\u0003\u00015\u0011q!W1s]*{'M\u0003\u0002\u0004\t\u0005!\u00110\u0019:o\u0015\t)a!A\u0002k_\nT!a\u0002\u0005\u0002\u000bM\fWN_1\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001aB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\u0011I!!\u0007\u0003\u0003\u0013M#(/Z1n\u0015>\u0014\u0007CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0007\u0003\u0011)H/\u001b7\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u000511m\u001c8gS\u001e\u0004\"aI\u0013\u000e\u0003\u0011R!!\t\u0004\n\u0005\u0019\"#AB\"p]\u001aLw\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u00031A\u0017\rZ8pa\u000e{gNZ5h!\tQs&D\u0001,\u0015\taS&\u0001\u0003d_:4'B\u0001\u0018\t\u0003\u0019A\u0017\rZ8pa&\u0011\u0001g\u000b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bI\u0002A\u0011A\u001a\u0002\rqJg.\u001b;?)\r!dg\u000e\t\u0003k\u0001i\u0011A\u0001\u0005\u0006CE\u0002\rA\t\u0005\u0006QE\u0002\r!\u000b\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0003\u0019\u0019G.[3oiV\t1\b\u0005\u00026y%\u0011QH\u0001\u0002\r\u00072LWM\u001c;IK2\u0004XM\u001d\u0005\u0007\u007f\u0001\u0001\u000b\u0011B\u001e\u0002\u000f\rd\u0017.\u001a8uA!9\u0011\t\u0001a\u0001\n\u0003\u0011\u0015!B1qa&#W#A\"\u0011\u0007\u0011;\u0015*D\u0001F\u0015\u00051\u0015!B:dC2\f\u0017B\u0001%F\u0005\u0019y\u0005\u000f^5p]B\u0011!\nU\u0007\u0002\u0017*\u0011A*T\u0001\be\u0016\u001cwN\u001d3t\u0015\tqu*A\u0002ba&T!aA\u0017\n\u0005E[%!D!qa2L7-\u0019;j_:LE\rC\u0004T\u0001\u0001\u0007I\u0011\u0001+\u0002\u0013\u0005\u0004\b/\u00133`I\u0015\fHCA+Y!\t!e+\u0003\u0002X\u000b\n!QK\\5u\u0011\u001dI&+!AA\u0002\r\u000b1\u0001\u001f\u00132\u0011\u0019Y\u0006\u0001)Q\u0005\u0007\u00061\u0011\r\u001d9JI\u0002Bq!\u0018\u0001C\u0002\u0013\u0005a,\u0001\u0006zCJt7i\u001c8gS\u001e,\u0012a\u0018\t\u0003G\u0001L!!\u0019\u0013\u0003\u0015e\u000b'O\\\"p]\u001aLw\r\u0003\u0004d\u0001\u0001\u0006IaX\u0001\fs\u0006\u0014hnQ8oM&<\u0007\u0005C\u0003f\u0001\u0011\u0005a-\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0002i!)\u0001\u000e\u0001C\u0001S\u0006iq/Y5u\r>\u0014h)\u001b8jg\"$\"A[7\u0011\u0005]Y\u0017B\u00017\u0005\u0005E\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8Ti\u0006$Xo\u001d\u0005\u0006]\u001e\u0004\ra\\\u0001\ni&lWm\\;u\u001bN\u0004\"\u0001\u00129\n\u0005E,%\u0001\u0002'p]\u001eDQa\u001d\u0001\u0005\u0002Q\fQb^1ji\u001a{'o\u0015;biV\u001cHc\u00016vo\")aO\u001da\u0001U\u000611\u000f^1ukNDQA\u001c:A\u0002=DQ!\u001f\u0001\u0005\u0002i\f\u0011bZ3u'R\fG/^:\u0015\u0003)DQ\u0001 \u0001\u0005\u0002\u0019\fAa[5mY\")a\u0010\u0001C\u0005\u0005\u0006Aq-\u001a;BaBLEmB\u0004\u0002\u0002\tA\t!a\u0001\u0002\u000fe\u000b'O\u001c&pEB\u0019Q'!\u0002\u0007\r\u0005\u0011\u0001\u0012AA\u0004'\u0015\t)!!\u0003\u001b!\r!\u00151B\u0005\u0004\u0003\u001b)%AB!osJ+g\rC\u00043\u0003\u000b!\t!!\u0005\u0015\u0005\u0005\r\u0001\"CA\u000b\u0003\u000b!\tAAA\f\u0003A\u0011W/\u001b7e\u000b:4\u0018N]8o[\u0016tG\u000f\u0006\u0005\u0002\u001a\u00055\u0012qFA\u0019!!\tY\"!\t\u0002(\u0005\u001dbb\u0001#\u0002\u001e%\u0019\u0011qD#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019#!\n\u0003\u00075\u000b\u0007OC\u0002\u0002 \u0015\u0003B!a\u0007\u0002*%!\u00111FA\u0013\u0005\u0019\u0019FO]5oO\"1\u0011%a\u0005A\u0002\tBa!XA\n\u0001\u0004y\u0006\u0002CA\u001a\u0003'\u0001\r!!\u000e\u0002\u0013)|'mQ8oM&<\u0007cA\u0012\u00028%\u0019\u0011\u0011\b\u0013\u0003\u0013){'mQ8oM&<\u0007\u0006BA\n\u0003{\u0001B!a\u0010\u0002R5\u0011\u0011\u0011\t\u0006\u0005\u0003\u0007\n)%A\u0006b]:|G/\u0019;j_:\u001c(\u0002BA$\u0003\u0013\naaY8n[>t'\u0002BA&\u0003\u001b\naaZ8pO2,'BAA(\u0003\r\u0019w.\\\u0005\u0005\u0003'\n\tEA\tWSNL'\r\\3G_J$Vm\u001d;j]\u001eD\u0011\"a\u0016\u0002\u0006\u0011\u0005!!!\u0017\u0002-\t,\u0018\u000e\u001c3K_\n\u001cun\u001c:eS:\fGo\u001c:D[\u0012$b!a\n\u0002\\\u0005u\u0003BB\u0011\u0002V\u0001\u0007!\u0005\u0003\u0005\u00024\u0005U\u0003\u0019AA\u001bQ\u0011\t)&!\u0010")
public class YarnJob
implements StreamJob,
Logging {
    private final Config config;
    private final ClientHelper client;
    private Option<ApplicationId> appId;
    private final YarnConfig yarnConfig;
    private final String loggerName;
    private final Logger logger;
    private final String startupLoggerName;
    private final Logger startupLogger;
    private volatile byte bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        YarnJob yarnJob = this;
        synchronized (yarnJob) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String startupLoggerName() {
        return this.startupLoggerName;
    }

    private Logger startupLogger$lzycompute() {
        YarnJob yarnJob = this;
        synchronized (yarnJob) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.startupLogger = Logging.class.startupLogger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.startupLogger;
        }
    }

    public Logger startupLogger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.startupLogger$lzycompute() : this.startupLogger;
    }

    public void org$apache$samza$util$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void org$apache$samza$util$Logging$_setter_$startupLoggerName_$eq(String x$1) {
        this.startupLoggerName = x$1;
    }

    public void startupLog(Function0<Object> message) {
        Logging.class.startupLog((Logging)this, message);
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void trace(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, message, e);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void debug(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, message, e);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void info(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.info((Logging)this, message, e);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, message, e);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public void error(Function0<Object> message, Function0<Throwable> e) {
        Logging.class.error((Logging)this, message, e);
    }

    public void putMDC(Function0<String> key, Function0<String> value) {
        Logging.class.putMDC((Logging)this, key, value);
    }

    public String getMDC(Function0<String> key) {
        return Logging.class.getMDC((Logging)this, key);
    }

    public void removeMDC(Function0<String> key) {
        Logging.class.removeMDC((Logging)this, key);
    }

    public void clearMDC() {
        Logging.class.clearMDC((Logging)this);
    }

    public ClientHelper client() {
        return this.client;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    public YarnConfig yarnConfig() {
        return this.yarnConfig;
    }

    public YarnJob submit() {
        try {
            JobConfig jobConfig = new JobConfig(this.config);
            String cmdExec = YarnJob$.MODULE$.buildJobCoordinatorCmd(this.config, jobConfig);
            scala.collection.immutable.Map<String, String> environment = YarnJob$.MODULE$.buildEnvironment(this.config, this.yarnConfig(), jobConfig);
            this.appId_$eq(this.client().submitApplication(this.config, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringOps(Predef$.MODULE$.augmentString("export SAMZA_LOG_DIR=%s && ln -sfn %s logs && exec %s 1>logs/%s 2>logs/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"<LOG_DIR>", "<LOG_DIR>", cmdExec, "stdout", "stderr"}))})), (Option<Map<String, String>>)new Some(environment), (Option<String>)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("%s_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobConfig.getName().get(), jobConfig.getJobId()})))));
            return this;
        }
        catch (Throwable throwable) {
            this.logger().error("Exception submitting yarn job.", throwable);
            try {
                try {
                    this.client().cleanupStagingDir();
                }
                catch (Throwable throwable2) {
                    this.logger().warn("Exception cleaning Staging Directory after failed launch attempt.", throwable2);
                }
            }
            finally {
                throw throwable;
            }
        }
    }

    public ApplicationStatus waitForFinish(long timeoutMs) {
        long startTimeMs = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMs < timeoutMs) {
            Option option = Option$.MODULE$.apply((Object)this.getStatus());
            if (option instanceof Some) {
                Some some = (Some)option;
                ApplicationStatus s = (ApplicationStatus)some.x();
                if (ApplicationStatus.SuccessfulFinish.equals((Object)s) || ApplicationStatus.UnsuccessfulFinish.equals((Object)s)) {
                    this.client().cleanupStagingDir();
                }
                return s;
            }
            if (None$.MODULE$.equals(option)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Thread.sleep(1000L);
                continue;
            }
            throw new MatchError((Object)option);
        }
        return this.getStatus();
    }

    public ApplicationStatus waitForStatus(ApplicationStatus status2, long timeoutMs) {
        long startTimeMs = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTimeMs < timeoutMs) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = Option$.MODULE$.apply((Object)this.getStatus());
                        if (!(option instanceof Some)) break block5;
                        Some some = (Some)option;
                        ApplicationStatus s = (ApplicationStatus)some.x();
                        if (status2.equals((Object)s)) {
                            return status2;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option)) break block7;
                    boxedUnit = null;
                }
                Thread.sleep(1000L);
                continue;
            }
            throw new MatchError((Object)option);
        }
        return this.getStatus();
    }

    public ApplicationStatus getStatus() {
        Option<ApplicationId> option;
        block4: {
            ApplicationStatus applicationStatus;
            block3: {
                block2: {
                    option = this.getAppId();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    ApplicationId appId = (ApplicationId)some.x();
                    this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Getting status for applicationId %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{appId})));
                    applicationStatus = (ApplicationStatus)this.client().status(appId).getOrElse((Function0)new Serializable(this, appId){
                        public static final long serialVersionUID = 0L;
                        private final ApplicationId appId$1;

                        public final Nothing$ apply() {
                            throw new SamzaException(new StringOps(Predef$.MODULE$.augmentString("No status was determined for applicationId %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.appId$1})));
                        }
                        {
                            this.appId$1 = appId$1;
                        }
                    });
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.logger().info("Unable to report status because no applicationId could be found.");
                applicationStatus = ApplicationStatus.SuccessfulFinish;
            }
            return applicationStatus;
        }
        throw new MatchError(option);
    }

    public YarnJob kill() {
        Option<ApplicationId> option;
        block8: {
            block7: {
                option = this.getAppId();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    ApplicationId appId = (ApplicationId)some.x();
                    this.logger().info("Killing applicationId {}", new Object[]{appId});
                    this.client().kill(appId);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                if (!None$.MODULE$.equals(option)) break block8;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return this;
        }
        throw new MatchError(option);
        finally {
            this.client().cleanupStagingDir();
        }
    }

    private Option<ApplicationId> getAppId() {
        Option<ApplicationId> option;
        block7: {
            Option option2;
            block10: {
                None$ none$;
                block6: {
                    None$ none$2;
                    block9: {
                        block8: {
                            Option option3;
                            block5: {
                                option = this.appId();
                                if (!(option instanceof Some)) break block5;
                                none$ = this.appId();
                                break block6;
                            }
                            if (!None$.MODULE$.equals(option)) break block7;
                            JobConfig jobConfig = new JobConfig(this.config);
                            option2 = ScalaJavaUtil.JavaOptionals$.MODULE$.toRichOptional(jobConfig.getName()).toOption();
                            if (!(option2 instanceof Some)) break block8;
                            Some some = (Some)option2;
                            String jobName = (String)some.x();
                            String applicationName = new StringOps(Predef$.MODULE$.augmentString("%s_%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{jobName, jobConfig.getJobId()}));
                            this.logger().info(new StringOps(Predef$.MODULE$.augmentString("Fetching status from YARN for application name %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{applicationName})));
                            List<ApplicationId> applicationIds = this.client().getActiveApplicationIds(applicationName);
                            if (applicationIds.nonEmpty()) {
                                this.logger().info(new StringBuilder().append((Object)"Matching active ids: ").append((Object)((List)applicationIds.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse().toString()).toString());
                                option3 = ((List)applicationIds.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse().headOption();
                            } else {
                                List<ApplicationId> pastApplicationIds = this.client().getPreviousApplicationIds(applicationName);
                                option3 = ((List)pastApplicationIds.sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).reverse().headOption();
                            }
                            none$2 = option3;
                            break block9;
                        }
                        if (!None$.MODULE$.equals(option2)) break block10;
                        none$2 = None$.MODULE$;
                    }
                    none$ = none$2;
                }
                return none$;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError(option);
    }

    public YarnJob(Config config, Configuration hadoopConfig) {
        this.config = config;
        Logging.class.$init$((Logging)this);
        this.client = new ClientHelper(hadoopConfig);
        this.appId = None$.MODULE$;
        this.yarnConfig = new YarnConfig(config);
    }
}

