/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.validation;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.samza.SamzaException;
import org.apache.samza.config.Config;
import org.apache.samza.config.JobConfig;
import org.apache.samza.container.LocalityManager;
import org.apache.samza.coordinator.metadatastore.CoordinatorStreamStore;
import org.apache.samza.coordinator.metadatastore.NamespaceAwareCoordinatorStreamStore;
import org.apache.samza.job.model.LocalityModel;
import org.apache.samza.job.model.ProcessorLocality;
import org.apache.samza.job.yarn.ClientHelper;
import org.apache.samza.metadatastore.MetadataStore;
import org.apache.samza.metrics.JmxMetricsAccessor;
import org.apache.samza.metrics.MetricsAccessor;
import org.apache.samza.metrics.MetricsRegistry;
import org.apache.samza.metrics.MetricsRegistryMap;
import org.apache.samza.metrics.MetricsValidator;
import org.apache.samza.util.CommandLine;
import org.apache.samza.util.ReflectionUtil;
import org.apache.samza.util.hadoop.HttpFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnJobValidationTool {
    private static final Logger log = LoggerFactory.getLogger(YarnJobValidationTool.class);
    private final JobConfig config;
    private final YarnClient client;
    private final String jobName;
    private final MetricsValidator validator;

    public YarnJobValidationTool(JobConfig config, YarnClient client, MetricsValidator validator) {
        this.config = config;
        this.client = client;
        String name = (String)this.config.getName().get();
        String jobId = this.config.getJobId();
        this.jobName = name + "_" + jobId;
        this.validator = validator;
    }

    public void run() {
        try {
            log.info("Start validating job " + this.jobName);
            ApplicationId appId = this.validateAppId();
            ApplicationAttemptId attemptId = this.validateRunningAttemptId(appId);
            this.validateContainerCount(attemptId);
            if (this.validator != null) {
                this.validateJmxMetrics();
            }
            log.info("End of validation");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    public ApplicationId validateAppId() throws Exception {
        ApplicationId appId = null;
        for (ApplicationReport applicationReport : this.client.getApplications()) {
            if (!applicationReport.getName().equals(this.jobName)) continue;
            ApplicationId id = applicationReport.getApplicationId();
            if (appId != null && appId.compareTo(id) >= 0) continue;
            appId = id;
        }
        if (appId != null) {
            log.info("Job lookup success. ApplicationId " + appId.toString());
            return appId;
        }
        throw new SamzaException("Job lookup failure " + this.jobName);
    }

    public ApplicationAttemptId validateRunningAttemptId(ApplicationId appId) throws Exception {
        ApplicationAttemptId attemptId = this.client.getApplicationReport(appId).getCurrentApplicationAttemptId();
        ApplicationAttemptReport attemptReport = this.client.getApplicationAttemptReport(attemptId);
        if (attemptReport.getYarnApplicationAttemptState() == YarnApplicationAttemptState.RUNNING) {
            log.info("Job is running. AttempId " + attemptId.toString());
            return attemptId;
        }
        throw new SamzaException("Job not running " + this.jobName);
    }

    public int validateContainerCount(ApplicationAttemptId attemptId) throws Exception {
        int runningContainerCount = 0;
        for (ContainerReport containerReport : this.client.getContainers(attemptId)) {
            if (containerReport.getContainerState() != ContainerState.RUNNING) continue;
            ++runningContainerCount;
        }
        int containerExpected = this.config.getContainerCount() + 1;
        if (runningContainerCount == containerExpected) {
            log.info("Container count matches. " + runningContainerCount + " containers are running.");
            return runningContainerCount;
        }
        throw new SamzaException("Container count does not match. " + runningContainerCount + " containers are running, while " + containerExpected + " is expected.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateJmxMetrics() throws Exception {
        MetricsRegistryMap metricsRegistry = new MetricsRegistryMap();
        coordinatorStreamStore.init();
        try (CoordinatorStreamStore coordinatorStreamStore = new CoordinatorStreamStore((Config)this.config, (MetricsRegistry)metricsRegistry);){
            LocalityManager localityManager = new LocalityManager((MetadataStore)new NamespaceAwareCoordinatorStreamStore((MetadataStore)coordinatorStreamStore, "set-config"));
            this.validator.init((Config)this.config);
            LocalityModel localityModel = localityManager.readLocality();
            for (ProcessorLocality processorLocality : localityModel.getProcessorLocalities().values()) {
                String containerId = processorLocality.id();
                String jmxUrl = processorLocality.jmxTunnelingUrl();
                if (!StringUtils.isNotBlank((CharSequence)jmxUrl)) continue;
                log.info("validate container " + containerId + " metrics with JMX: " + jmxUrl);
                JmxMetricsAccessor jmxMetrics = new JmxMetricsAccessor(jmxUrl);
                jmxMetrics.connect();
                this.validator.validate((MetricsAccessor)jmxMetrics);
                jmxMetrics.close();
                log.info("validate container " + containerId + " successfully");
            }
            this.validator.complete();
        }
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmdline = new CommandLine();
        OptionParser parser = cmdline.parser();
        ArgumentAcceptingOptionSpec validatorOpt = parser.accepts("metrics-validator", "The metrics validator class.").withOptionalArg().ofType(String.class).describedAs("com.foo.bar.ClassName");
        OptionSet options = cmdline.parser().parse(args);
        Config config = cmdline.loadConfig(options);
        MetricsValidator validator = null;
        if (options.has((OptionSpec)validatorOpt)) {
            String validatorClass = (String)options.valueOf((OptionSpec)validatorOpt);
            validator = (MetricsValidator)ReflectionUtil.getObj((String)validatorClass, MetricsValidator.class);
        }
        YarnConfiguration hadoopConfig = new YarnConfiguration();
        hadoopConfig.set("fs.http.impl", HttpFileSystem.class.getName());
        hadoopConfig.set("fs.https.impl", HttpFileSystem.class.getName());
        ClientHelper clientHelper = new ClientHelper((Configuration)hadoopConfig);
        new YarnJobValidationTool(new JobConfig(config), clientHelper.yarnClient(), validator).run();
    }
}

