/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.webapp;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.samza.SamzaException;
import org.apache.samza.serializers.model.SamzaObjectMapper;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class ApplicationMasterRestClient
implements Closeable {
    private final CloseableHttpClient httpClient;
    private final HttpHost appMasterHost;
    private final ObjectMapper jsonMapper = SamzaObjectMapper.getObjectMapper();

    public ApplicationMasterRestClient(CloseableHttpClient client, String amHostName, int amRpcPort) {
        this.httpClient = client;
        this.appMasterHost = new HttpHost(amHostName, amRpcPort);
    }

    public Map<String, Map<String, Object>> getMetrics() throws IOException {
        String jsonString = this.getEntityAsJson("/metrics", "metrics");
        return (Map)this.jsonMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Map<String, Object>>>(){});
    }

    public Map<String, Object> getTaskContext() throws IOException {
        String jsonString = this.getEntityAsJson("/task-context", "task context");
        return (Map)this.jsonMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getAmState() throws IOException {
        String jsonString = this.getEntityAsJson("/am", "AM state");
        return (Map)this.jsonMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> getConfig() throws IOException {
        String jsonString = this.getEntityAsJson("/config", "config");
        return (Map)this.jsonMapper.readValue(jsonString, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    private String getEntityAsJson(String path, String entityName) throws IOException {
        HttpGet getRequest = new HttpGet(path);
        CloseableHttpResponse httpResponse = this.httpClient.execute(this.appMasterHost, (HttpRequest)getRequest);
        StatusLine status2 = httpResponse.getStatusLine();
        if (status2.getStatusCode() != 200) {
            throw new SamzaException(String.format("Error retrieving %s from host %s. Response: %s", entityName, this.appMasterHost.toURI(), status2.getReasonPhrase()));
        }
        return EntityUtils.toString((HttpEntity)httpResponse.getEntity());
    }

    public String toString() {
        return "AppMasterClient for uri: " + this.appMasterHost.toURI().toString();
    }
}

