/*
 * Decompiled with CFR 0.152.
 */
package org.apache.samza.webapp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.samza.container.ContainerHeartbeatResponse;
import org.apache.samza.job.yarn.SamzaAppMasterMetrics;
import org.apache.samza.job.yarn.YarnAppState;
import org.apache.samza.job.yarn.YarnContainer;
import org.apache.samza.metrics.Counter;
import org.apache.samza.metrics.ReadableMetricsRegistry;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnContainerHeartbeatServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(YarnContainerHeartbeatServlet.class);
    private static final String APPLICATION_JSON = "application/json";
    private static final String GROUP = SamzaAppMasterMetrics.class.getName();
    private final Counter heartbeatsExpiredCount;
    private YarnAppState yarnAppState;
    private ObjectMapper mapper;

    public YarnContainerHeartbeatServlet(YarnAppState yarnAppState, ReadableMetricsRegistry registry) {
        this.yarnAppState = yarnAppState;
        this.mapper = new ObjectMapper();
        this.heartbeatsExpiredCount = registry.newCounter(GROUP, "heartbeats-expired");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter printWriter = resp.getWriter();
        String containerIdParam = req.getParameter("executionContainerId");
        resp.setContentType(APPLICATION_JSON);
        boolean alive = false;
        try {
            ContainerId yarnContainerId = ContainerId.fromString((String)containerIdParam);
            for (YarnContainer yarnContainer : this.yarnAppState.runningProcessors.values()) {
                if (yarnContainer.id().compareTo(yarnContainerId) != 0) continue;
                alive = true;
                break;
            }
            if (!alive) {
                this.heartbeatsExpiredCount.inc();
            }
            ContainerHeartbeatResponse response = new ContainerHeartbeatResponse(alive);
            printWriter.write(this.mapper.writeValueAsString((Object)response));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Container ID {} passed is invalid", (Object)containerIdParam);
            resp.sendError(400, e.getMessage());
        }
    }
}

