/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.storage.implementations;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.xml.security.keys.storage.StorageResolverException;
import org.apache.xml.security.keys.storage.StorageResolverSpi;

public class KeyStoreResolver
extends StorageResolverSpi {
    KeyStore _keyStore = null;

    public KeyStoreResolver(KeyStore keyStore) throws StorageResolverException {
        this._keyStore = keyStore;
        try {
            this._keyStore.aliases();
        }
        catch (KeyStoreException ex) {
            throw new StorageResolverException("generic.EmptyMessage", ex);
        }
    }

    public Iterator getIterator() {
        return new KeyStoreIterator(this._keyStore);
    }

    static class KeyStoreIterator
    implements Iterator {
        KeyStore _keyStore = null;
        Enumeration _aliases = null;
        Certificate _nextCert = null;

        public KeyStoreIterator(KeyStore keyStore) {
            try {
                this._keyStore = keyStore;
                this._aliases = this._keyStore.aliases();
            }
            catch (KeyStoreException ex) {
                this._aliases = new Enumeration(){

                    public boolean hasMoreElements() {
                        return false;
                    }

                    public Object nextElement() {
                        return null;
                    }
                };
            }
        }

        public boolean hasNext() {
            if (this._nextCert == null) {
                this._nextCert = this.findNextCert();
            }
            return this._nextCert != null;
        }

        public Object next() {
            if (this._nextCert == null) {
                this._nextCert = this.findNextCert();
                if (this._nextCert == null) {
                    throw new NoSuchElementException();
                }
            }
            Certificate ret = this._nextCert;
            this._nextCert = null;
            return ret;
        }

        public void remove() {
            throw new UnsupportedOperationException("Can't remove keys from KeyStore");
        }

        private Certificate findNextCert() {
            while (this._aliases.hasMoreElements()) {
                String alias = (String)this._aliases.nextElement();
                try {
                    Certificate cert = this._keyStore.getCertificate(alias);
                    if (cert == null) continue;
                    return cert;
                }
                catch (KeyStoreException ex) {
                    return null;
                }
            }
            return null;
        }
    }
}

