/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.ClassLoaderUtils;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    private static Log log = LogFactory.getLog((String)Transform.class.getName());
    private static boolean alreadyInitialized = false;
    private static HashMap transformClassHash = null;
    private static HashMap transformSpiHash = new HashMap();
    private TransformSpi transformSpi = null;

    public Transform(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        super(doc);
        this._constructionElement.setAttributeNS(null, "Algorithm", algorithmURI);
        this.transformSpi = Transform.getTransformSpi(algorithmURI);
        if (this.transformSpi == null) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create URI \"" + algorithmURI + "\" class \"" + this.transformSpi.getClass() + "\""));
            log.debug((Object)("The NodeList is " + contextNodes));
        }
        if (contextNodes != null) {
            for (int i = 0; i < contextNodes.getLength(); ++i) {
                this._constructionElement.appendChild(contextNodes.item(i).cloneNode(true));
            }
        }
    }

    public Transform(Element element, String BaseURI) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, BaseURI);
        String algorithmURI = element.getAttributeNS(null, "Algorithm");
        if (algorithmURI == null || algorithmURI.length() == 0) {
            Object[] exArgs = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", exArgs);
        }
        this.transformSpi = Transform.getTransformSpi(algorithmURI);
        if (this.transformSpi == null) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
    }

    public static Transform getInstance(Document doc, String algorithmURI) throws InvalidTransformException {
        return Transform.getInstance(doc, algorithmURI, (NodeList)null);
    }

    public static Transform getInstance(Document doc, String algorithmURI, Element contextChild) throws InvalidTransformException {
        HelperNodeList contextNodes = null;
        if (contextChild != null) {
            contextNodes = new HelperNodeList();
            XMLUtils.addReturnToElement(doc, contextNodes);
            contextNodes.appendChild(contextChild);
            XMLUtils.addReturnToElement(doc, contextNodes);
        }
        return Transform.getInstance(doc, algorithmURI, contextNodes);
    }

    public static Transform getInstance(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        return new Transform(doc, algorithmURI, contextNodes);
    }

    public static void init() {
        if (!alreadyInitialized) {
            transformClassHash = new HashMap(10);
            alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        Class registeredClass = Transform.getImplementingClass(algorithmURI);
        if (registeredClass != null) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        try {
            transformClassHash.put(algorithmURI, ClassLoaderUtils.loadClass(implementingClass, Transform.class));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, this);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input, OutputStream os) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, os, this);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    private static Class getImplementingClass(String URI2) {
        return (Class)transformClassHash.get(URI2);
    }

    private static TransformSpi getTransformSpi(String URI2) throws InvalidTransformException {
        try {
            Object value = transformSpiHash.get(URI2);
            if (value != null) {
                return (TransformSpi)value;
            }
            Class cl = (Class)transformClassHash.get(URI2);
            if (cl != null) {
                TransformSpi tr = (TransformSpi)cl.newInstance();
                transformSpiHash.put(URI2, tr);
                return tr;
            }
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{URI2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{URI2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        return null;
    }

    public String getBaseLocalName() {
        return "Transform";
    }
}

