/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.exceptions;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.apache.xml.security.utils.I18n;

public class XMLSecurityRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    protected Exception originalException = null;
    protected String msgID;

    public XMLSecurityRuntimeException() {
        super("Missing message string");
        this.msgID = null;
        this.originalException = null;
    }

    public XMLSecurityRuntimeException(String msgID) {
        super(I18n.getExceptionMessage(msgID));
        this.msgID = msgID;
        this.originalException = null;
    }

    public XMLSecurityRuntimeException(String msgID, Object[] exArgs) {
        super(MessageFormat.format(I18n.getExceptionMessage(msgID), exArgs));
        this.msgID = msgID;
        this.originalException = null;
    }

    public XMLSecurityRuntimeException(Exception originalException) {
        super("Missing message ID to locate message string in resource bundle \"org/apache/xml/security/resource/xmlsecurity\". Original Exception was a " + originalException.getClass().getName() + " and message " + originalException.getMessage());
        this.originalException = originalException;
    }

    public XMLSecurityRuntimeException(String msgID, Exception originalException) {
        super(I18n.getExceptionMessage(msgID, originalException));
        this.msgID = msgID;
        this.originalException = originalException;
    }

    public XMLSecurityRuntimeException(String msgID, Object[] exArgs, Exception originalException) {
        super(MessageFormat.format(I18n.getExceptionMessage(msgID), exArgs));
        this.msgID = msgID;
        this.originalException = originalException;
    }

    public String getMsgID() {
        if (this.msgID == null) {
            return "Missing message ID";
        }
        return this.msgID;
    }

    public String toString() {
        String s = this.getClass().getName();
        String message = super.getLocalizedMessage();
        message = message != null ? s + ": " + message : s;
        if (this.originalException != null) {
            message = message + "\nOriginal Exception was " + this.originalException.toString();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            super.printStackTrace(System.err);
            if (this.originalException != null) {
                this.originalException.printStackTrace(System.err);
            }
        }
    }

    public void printStackTrace(PrintWriter printwriter) {
        super.printStackTrace(printwriter);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printwriter);
        }
    }

    public void printStackTrace(PrintStream printstream) {
        super.printStackTrace(printstream);
        if (this.originalException != null) {
            this.originalException.printStackTrace(printstream);
        }
    }

    public Exception getOriginalException() {
        return this.originalException;
    }
}

