/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    private static Log log = LogFactory.getLog(ResolverFragment.class);

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr uri, String baseURI) throws ResourceResolverException {
        String uriNodeValue = uri.getNodeValue();
        Document doc = uri.getOwnerElement().getOwnerDocument();
        Node selectedElem = null;
        if (uriNodeValue.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ResolverFragment with empty URI (means complete document)");
            }
            selectedElem = doc;
        } else {
            Element start;
            String id = uriNodeValue.substring(1);
            selectedElem = doc.getElementById(id);
            if (selectedElem == null) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MissingID", exArgs, uri, baseURI);
            }
            if (this.secureValidation && !XMLUtils.protectAgainstWrappingAttack(start = uri.getOwnerDocument().getDocumentElement(), id)) {
                Object[] exArgs = new Object[]{id};
                throw new ResourceResolverException("signature.Verification.MultipleIDs", exArgs, uri, baseURI);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try to catch an Element with ID " + id + " and Element was " + selectedElem));
            }
        }
        XMLSignatureInput result = new XMLSignatureInput(selectedElem);
        result.setExcludeComments(true);
        result.setMIMEType("text/xml");
        if (baseURI != null && baseURI.length() > 0) {
            result.setSourceURI(baseURI.concat(uri.getNodeValue()));
        } else {
            result.setSourceURI(uri.getNodeValue());
        }
        return result;
    }

    public boolean engineCanResolve(Attr uri, String baseURI) {
        if (uri == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Quick fail for null uri");
            }
            return false;
        }
        String uriNodeValue = uri.getNodeValue();
        if (uriNodeValue.equals("") || uriNodeValue.charAt(0) == '#' && (uriNodeValue.charAt(1) != 'x' || !uriNodeValue.startsWith("#xpointer("))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("State I can resolve reference: \"" + uriNodeValue + "\""));
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Do not seem to be able to resolve reference: \"" + uriNodeValue + "\""));
        }
        return false;
    }
}

