/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl.processor.input;

import java.util.ArrayDeque;
import javax.xml.stream.XMLStreamException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.AbstractInputProcessor;
import org.apache.xml.security.stax.ext.InputProcessorChain;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.ext.stax.XMLSecEndElement;
import org.apache.xml.security.stax.ext.stax.XMLSecEvent;
import org.apache.xml.security.stax.ext.stax.XMLSecStartElement;
import org.apache.xml.security.stax.impl.processor.input.XMLDecryptInputProcessor;
import org.apache.xml.security.stax.impl.processor.input.XMLEventReaderInputProcessor;
import org.apache.xml.security.stax.impl.processor.input.XMLSignatureInputHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLSecurityInputProcessor
extends AbstractInputProcessor {
    protected static final transient Logger logger = LoggerFactory.getLogger(XMLSecurityInputProcessor.class);
    private final ArrayDeque<XMLSecEvent> xmlSecEventList = new ArrayDeque();
    private int eventCount = 0;
    private int startIndexForProcessor = 0;

    public XMLSecurityInputProcessor(XMLSecurityProperties securityProperties) {
        super(securityProperties);
        this.setPhase(XMLSecurityConstants.Phase.POSTPROCESSING);
    }

    @Override
    public XMLSecEvent processNextHeaderEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
        return null;
    }

    @Override
    public XMLSecEvent processNextEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
        XMLSecEvent xmlSecEvent;
        InputProcessorChain subInputProcessorChain = inputProcessorChain.createSubChain(this);
        InternalBufferProcessor internalBufferProcessor = new InternalBufferProcessor(this.getSecurityProperties());
        subInputProcessorChain.addProcessor(internalBufferProcessor);
        boolean signatureElementFound = false;
        block4: do {
            subInputProcessorChain.reset();
            xmlSecEvent = subInputProcessorChain.processHeaderEvent();
            ++this.eventCount;
            switch (xmlSecEvent.getEventType()) {
                case 1: {
                    final XMLSecStartElement xmlSecStartElement = xmlSecEvent.asStartElement();
                    if (xmlSecStartElement.getName().equals(XMLSecurityConstants.TAG_dsig_Signature)) {
                        signatureElementFound = true;
                        this.startIndexForProcessor = this.eventCount - 1;
                        break;
                    }
                    if (!xmlSecStartElement.getName().equals(XMLSecurityConstants.TAG_xenc_EncryptedData)) break;
                    XMLDecryptInputProcessor inputProcessor = new XMLDecryptInputProcessor(this.getSecurityProperties());
                    subInputProcessorChain.addProcessor(inputProcessor);
                    subInputProcessorChain.removeProcessor(internalBufferProcessor);
                    InternalReplayProcessor internalReplayProcessor = new InternalReplayProcessor(this.getSecurityProperties());
                    internalReplayProcessor.setPhase(XMLSecurityConstants.Phase.PROCESSING);
                    internalReplayProcessor.getAfterProcessors().clear();
                    internalReplayProcessor.getBeforeProcessors().clear();
                    internalReplayProcessor.addAfterProcessor(XMLDecryptInputProcessor.class.getName());
                    subInputProcessorChain.addProcessor(internalReplayProcessor);
                    AbstractInputProcessor abstractInputProcessor = new AbstractInputProcessor(this.getSecurityProperties()){

                        @Override
                        public XMLSecEvent processNextHeaderEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
                            return null;
                        }

                        @Override
                        public XMLSecEvent processNextEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
                            inputProcessorChain.removeProcessor(this);
                            return xmlSecStartElement;
                        }
                    };
                    abstractInputProcessor.setPhase(XMLSecurityConstants.Phase.PREPROCESSING);
                    abstractInputProcessor.addBeforeProcessor(XMLSecurityInputProcessor.class.getName());
                    abstractInputProcessor.addAfterProcessor(XMLEventReaderInputProcessor.class.getName());
                    subInputProcessorChain.addProcessor(abstractInputProcessor);
                    subInputProcessorChain.removeProcessor(this);
                    inputProcessorChain.getProcessors().clear();
                    inputProcessorChain.getProcessors().addAll(subInputProcessorChain.getProcessors());
                    this.xmlSecEventList.pollFirst();
                    return this.xmlSecEventList.pollLast();
                }
                case 2: {
                    XMLSecEndElement xmlSecEndElement = xmlSecEvent.asEndElement();
                    if (!signatureElementFound || !xmlSecEndElement.getName().equals(XMLSecurityConstants.TAG_dsig_Signature)) continue block4;
                    XMLSignatureInputHandler inputHandler = new XMLSignatureInputHandler();
                    inputHandler.handle(subInputProcessorChain, this.getSecurityProperties(), this.xmlSecEventList, this.startIndexForProcessor);
                    subInputProcessorChain.removeProcessor(internalBufferProcessor);
                    subInputProcessorChain.addProcessor(new InternalReplayProcessor(this.getSecurityProperties()));
                    subInputProcessorChain.removeProcessor(this);
                    inputProcessorChain.getProcessors().clear();
                    inputProcessorChain.getProcessors().addAll(subInputProcessorChain.getProcessors());
                    return this.xmlSecEventList.pollLast();
                }
            }
        } while (!xmlSecEvent.isEndDocument());
        throw new XMLSecurityException("stax.unsecuredMessage");
    }

    public class InternalReplayProcessor
    extends AbstractInputProcessor {
        public InternalReplayProcessor(XMLSecurityProperties securityProperties) {
            super(securityProperties);
            this.setPhase(XMLSecurityConstants.Phase.PREPROCESSING);
            this.addBeforeProcessor(XMLSecurityInputProcessor.class.getName());
            this.addAfterProcessor(XMLEventReaderInputProcessor.class.getName());
        }

        @Override
        public XMLSecEvent processNextHeaderEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
            return null;
        }

        @Override
        public XMLSecEvent processNextEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
            if (!XMLSecurityInputProcessor.this.xmlSecEventList.isEmpty()) {
                return (XMLSecEvent)XMLSecurityInputProcessor.this.xmlSecEventList.pollLast();
            }
            inputProcessorChain.removeProcessor(this);
            return inputProcessorChain.processEvent();
        }
    }

    public class InternalBufferProcessor
    extends AbstractInputProcessor {
        InternalBufferProcessor(XMLSecurityProperties securityProperties) {
            super(securityProperties);
            this.setPhase(XMLSecurityConstants.Phase.POSTPROCESSING);
            this.addBeforeProcessor(XMLSecurityInputProcessor.class.getName());
        }

        @Override
        public XMLSecEvent processNextHeaderEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
            XMLSecEvent xmlSecEvent = inputProcessorChain.processHeaderEvent();
            XMLSecurityInputProcessor.this.xmlSecEventList.push(xmlSecEvent);
            return xmlSecEvent;
        }

        @Override
        public XMLSecEvent processNextEvent(InputProcessorChain inputProcessorChain) throws XMLStreamException, XMLSecurityException {
            return null;
        }
    }
}

