/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.seata.common.util.ReflectionUtil;

public class DubboUtil {
    private static final String ALIBABA_DUBBO_PROXY_NAME_PREFIX = "com.alibaba.dubbo.common.bytecode.proxy";
    private static final String APACHE_DUBBO_PROXY_NAME_PREFIX = "org.apache.dubbo.common.bytecode.proxy";
    private static final String DUBBO_3_X_PARTIAL_PROXY_NAME = "DubboProxy";

    private DubboUtil() {
    }

    public static Class<?> getAssistInterface(Object proxyBean) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (proxyBean == null) {
            return null;
        }
        if (!DubboUtil.isDubboProxyName(proxyBean.getClass().getName())) {
            return null;
        }
        Field handlerField = proxyBean.getClass().getDeclaredField("handler");
        handlerField.setAccessible(true);
        Object invokerInvocationHandler = handlerField.get(proxyBean);
        Field invokerField = invokerInvocationHandler.getClass().getDeclaredField("invoker");
        invokerField.setAccessible(true);
        Object invoker = invokerField.get(invokerInvocationHandler);
        Field failoverClusterInvokerField = invoker.getClass().getDeclaredField("invoker");
        failoverClusterInvokerField.setAccessible(true);
        Object failoverClusterInvoker = failoverClusterInvokerField.get(invoker);
        return (Class)ReflectionUtil.invokeMethod(failoverClusterInvoker, "getInterface");
    }

    public static boolean isDubboProxyName(String name) {
        return name.startsWith(ALIBABA_DUBBO_PROXY_NAME_PREFIX) || name.startsWith(APACHE_DUBBO_PROXY_NAME_PREFIX) || name.contains(DUBBO_3_X_PARTIAL_PROXY_NAME);
    }
}

