/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import org.apache.seata.common.util.DateUtil;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.ResourceManager;
import org.apache.seata.core.protocol.transaction.UndoLogDeleteRequest;
import org.apache.seata.rm.AbstractRMHandler;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.rm.datasource.DataSourceManager;
import org.apache.seata.rm.datasource.DataSourceProxy;
import org.apache.seata.rm.datasource.undo.UndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RMHandlerAT
extends AbstractRMHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RMHandlerAT.class);
    private static final int LIMIT_ROWS = 3000;

    @Override
    public void handle(UndoLogDeleteRequest request) {
        String resourceId = request.getResourceId();
        DataSourceManager dataSourceManager = (DataSourceManager)this.getResourceManager();
        DataSourceProxy dataSourceProxy = dataSourceManager.get(resourceId);
        if (dataSourceProxy == null) {
            LOGGER.warn("Failed to get dataSourceProxy for delete undolog on {}", (Object)resourceId);
            return;
        }
        Date division = this.getLogCreated(request.getSaveDays());
        UndoLogManager manager = this.getUndoLogManager(dataSourceProxy);
        try (Connection conn = this.getConnection(dataSourceProxy);){
            int deleteRows;
            if (conn == null) {
                LOGGER.warn("Failed to get connection to delete expired undo_log for {}", (Object)resourceId);
                return;
            }
            while ((deleteRows = this.deleteUndoLog(manager, conn, division)) == 3000) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    Connection getConnection(DataSourceProxy dataSourceProxy) {
        try {
            return dataSourceProxy.getPlainConnection();
        }
        catch (SQLException e) {
            String resourceId = dataSourceProxy.getResourceId();
            LOGGER.error("Failed to get connection for {}", (Object)resourceId, (Object)e);
            return null;
        }
    }

    UndoLogManager getUndoLogManager(DataSourceProxy dataSourceProxy) {
        return UndoLogManagerFactory.getUndoLogManager(dataSourceProxy.getDbType());
    }

    int deleteUndoLog(UndoLogManager manager, Connection conn, Date division) {
        try {
            int deleteRows = manager.deleteUndoLogByLogCreated(division, 3000, conn);
            if (!conn.getAutoCommit()) {
                conn.commit();
            }
            return deleteRows;
        }
        catch (SQLException e) {
            LOGGER.error("Failed to delete expired undo_log", (Throwable)e);
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException re) {
                LOGGER.error("Failed to rollback undolog", (Throwable)re);
            }
            return 0;
        }
    }

    private Date getLogCreated(int pastDays) {
        if (pastDays <= 0) {
            pastDays = 7;
        }
        try {
            return DateUtil.getDateNowPlusDays(-pastDays);
        }
        catch (ParseException exx) {
            throw new RuntimeException(exx);
        }
    }

    @Override
    protected ResourceManager getResourceManager() {
        return DefaultResourceManager.get().getResourceManager(BranchType.AT);
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

