/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.ConnectionContext;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exception.TableMetaException;
import org.apache.seata.rm.datasource.exec.BaseTransactionalExecutor;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDMLBaseExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDMLBaseExecutor.class);
    protected static final String WHERE = " WHERE ";
    protected static final String GROUP_BY = " GROUP BY ";

    public AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    public AbstractDMLBaseExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, List<SQLRecognizer> sqlRecognizers) {
        super(statementProxy, statementCallback, sqlRecognizers);
    }

    @Override
    public T doExecute(Object ... args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        if (connectionProxy.getAutoCommit()) {
            return this.executeAutoCommitTrue(args);
        }
        return this.executeAutoCommitFalse(args);
    }

    protected T executeAutoCommitFalse(Object[] args) throws Exception {
        try {
            TableRecords beforeImage = this.beforeImage();
            Object result = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
            TableRecords afterImage = this.afterImage(beforeImage);
            this.prepareUndoLog(beforeImage, afterImage);
            return result;
        }
        catch (TableMetaException e) {
            LOGGER.error("table meta will be refreshed later, due to TableMetaException, table:{}, column:{}", (Object)e.getTableName(), (Object)e.getColumnName());
            this.statementProxy.getConnectionProxy().getDataSourceProxy().tableMetaRefreshEvent();
            throw e;
        }
    }

    private boolean isMultiPk() {
        if (null != this.sqlRecognizer) {
            return this.getTableMeta().getPrimaryKeyOnlyName().size() > 1;
        }
        if (CollectionUtils.isNotEmpty(this.sqlRecognizers)) {
            List distinctSQLRecognizer = this.sqlRecognizers.stream().filter(AbstractDMLBaseExecutor.distinctByKey(t -> t.getTableName())).collect(Collectors.toList());
            for (SQLRecognizer sqlRecognizer : distinctSQLRecognizer) {
                if (this.getTableMeta(sqlRecognizer.getTableName()).getPrimaryKeyOnlyName().size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        HashMap map = new HashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    protected T executeAutoCommitTrue(Object[] args) throws Throwable {
        ConnectionProxy connectionProxy = this.statementProxy.getConnectionProxy();
        try {
            connectionProxy.changeAutoCommit();
            Object object = new LockRetryPolicy(connectionProxy).execute(() -> {
                T result = this.executeAutoCommitFalse(args);
                connectionProxy.commit();
                return result;
            });
            return (T)object;
        }
        catch (Exception e) {
            LOGGER.error("execute executeAutoCommitTrue error:{}", (Object)e.getMessage(), (Object)e);
            if (!LockRetryPolicy.isLockRetryPolicyBranchRollbackOnConflict()) {
                connectionProxy.getTargetConnection().rollback();
            }
            throw e;
        }
        finally {
            connectionProxy.getContext().reset();
            connectionProxy.setAutoCommit(true);
        }
    }

    protected abstract TableRecords beforeImage() throws SQLException;

    protected abstract TableRecords afterImage(TableRecords var1) throws SQLException;

    private static class LockRetryPolicy
    extends ConnectionProxy.LockRetryPolicy {
        LockRetryPolicy(ConnectionProxy connection) {
            super(connection);
        }

        @Override
        public <T> T execute(Callable<T> callable) throws Exception {
            if (LOCK_RETRY_POLICY_BRANCH_ROLLBACK_ON_CONFLICT) {
                return this.doRetryOnLockConflict(callable);
            }
            return callable.call();
        }

        @Override
        protected void onException(Exception e) throws Exception {
            ConnectionContext context = this.connection.getContext();
            context.removeSavepoint(null);
            this.connection.getTargetConnection().rollback();
        }

        public static boolean isLockRetryPolicyBranchRollbackOnConflict() {
            return LOCK_RETRY_POLICY_BRANCH_ROLLBACK_ON_CONFLICT;
        }
    }
}

