/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.dm;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.BlobUtils;
import org.apache.seata.core.compressor.CompressorType;
import org.apache.seata.rm.datasource.undo.AbstractUndoLogManager;
import org.apache.seata.rm.datasource.undo.UndoLogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LoadLevel(name="dm")
public class DmUndoLogManager
extends AbstractUndoLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmUndoLogManager.class);
    private static final String INSERT_UNDO_LOG_SQL = "INSERT INTO " + UNDO_LOG_TABLE_NAME + " (" + "branch_id" + ", " + "xid" + ", \"" + "context".toUpperCase() + "\", " + "rollback_info" + ", " + "log_status" + ", " + "log_created" + ", " + "log_modified" + ")VALUES (?, ?, ?, ?, ?, sysdate, sysdate)";
    private static final String DELETE_UNDO_LOG_BY_CREATE_SQL = "DELETE FROM " + UNDO_LOG_TABLE_NAME + " WHERE " + "log_created" + " <= ? and ROWNUM <= ?";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int deleteUndoLogByLogCreated(Date logCreated, int limitRows, Connection conn) throws SQLException {
        try (PreparedStatement deletePST = conn.prepareStatement(DELETE_UNDO_LOG_BY_CREATE_SQL);){
            deletePST.setDate(1, new java.sql.Date(logCreated.getTime()));
            deletePST.setInt(2, limitRows);
            int deleteRows = deletePST.executeUpdate();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("batch delete undo log size {}", (Object)deleteRows);
            }
            int n = deleteRows;
            return n;
        }
        catch (Exception e2222) {
            if (e2222 instanceof SQLException) throw (SQLException)e2222;
            SQLException e2222 = new SQLException(e2222);
            throw (SQLException)e2222;
        }
    }

    @Override
    protected void insertUndoLogWithNormal(String xid, long branchId, String rollbackCtx, byte[] undoLogContent, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, rollbackCtx, undoLogContent, AbstractUndoLogManager.State.Normal, conn);
    }

    @Override
    protected void insertUndoLogWithGlobalFinished(String xid, long branchId, UndoLogParser parser, Connection conn) throws SQLException {
        this.insertUndoLog(xid, branchId, this.buildContext(parser.getName(), CompressorType.NONE), parser.getDefaultContent(), AbstractUndoLogManager.State.GlobalFinished, conn);
    }

    @Override
    protected byte[] getRollbackInfo(ResultSet rs) throws SQLException {
        Blob b = rs.getBlob("rollback_info");
        byte[] rollbackInfo = BlobUtils.blob2Bytes(b);
        return rollbackInfo;
    }

    private void insertUndoLog(String xid, long branchID, String rollbackCtx, byte[] undoLogContent, AbstractUndoLogManager.State state, Connection conn) throws SQLException {
        try (PreparedStatement pst = conn.prepareStatement(INSERT_UNDO_LOG_SQL);){
            pst.setLong(1, branchID);
            pst.setString(2, xid);
            pst.setString(3, rollbackCtx);
            pst.setBytes(4, undoLogContent);
            pst.setInt(5, state.getValue());
            pst.executeUpdate();
        }
        catch (Exception e2) {
            SQLException e2;
            if (!(e2 instanceof SQLException)) {
                e2 = new SQLException(e2);
            }
            throw (SQLException)e2;
        }
    }
}

