/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import org.apache.seata.rm.BaseDataSourceResource;
import org.apache.seata.rm.datasource.xa.ConnectionProxyXA;
import org.apache.seata.rm.datasource.xa.XAXid;

public abstract class AbstractDataSourceProxyXA
extends BaseDataSourceResource<ConnectionProxyXA> {
    protected static final String DEFAULT_RESOURCE_GROUP_ID = "DEFAULT_XA";

    public ConnectionProxyXA getConnectionForXAFinish(XAXid xaXid) throws SQLException {
        String xaBranchXid = xaXid.toString();
        ConnectionProxyXA connectionProxyXA = (ConnectionProxyXA)this.lookup(xaBranchXid);
        if (connectionProxyXA != null) {
            if (connectionProxyXA.getWrappedConnection().isClosed()) {
                this.release(xaBranchXid, connectionProxyXA);
            } else {
                return connectionProxyXA;
            }
        }
        return (ConnectionProxyXA)this.getConnectionProxyXA();
    }

    protected abstract Connection getConnectionProxyXA() throws SQLException;

    public void forceClosePhysicalConnection(XAXid xaXid) throws SQLException {
        ConnectionProxyXA connectionProxyXA = (ConnectionProxyXA)this.lookup(xaXid.toString());
        if (connectionProxyXA != null) {
            connectionProxyXA.close();
            Connection physicalConn = connectionProxyXA.getWrappedConnection();
            if (physicalConn instanceof PooledConnection) {
                physicalConn = ((PooledConnection)((Object)physicalConn)).getConnection();
            }
            physicalConn.close();
        }
    }
}

