/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.rm.BaseDataSourceResource;
import org.apache.seata.rm.DefaultResourceManager;
import org.apache.seata.rm.datasource.xa.AbstractConnectionProxyXA;
import org.apache.seata.rm.datasource.xa.Holdable;
import org.apache.seata.rm.datasource.xa.XAXid;
import org.apache.seata.rm.datasource.xa.XAXidBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProxyXA
extends AbstractConnectionProxyXA
implements Holdable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxyXA.class);
    private static final int BRANCH_EXECUTION_TIMEOUT = ConfigurationFactory.getInstance().getInt("client.rm.branchExecutionTimeoutXA", 60000);
    private volatile boolean currentAutoCommitStatus = true;
    private volatile XAXid xaBranchXid;
    private volatile boolean xaActive = false;
    private volatile boolean xaEnded = false;
    private volatile boolean kept = false;
    private volatile boolean rollBacked = false;
    private volatile Long branchRegisterTime = null;
    private volatile Long prepareTime = null;
    private static final Integer TIMEOUT = Math.max(BRANCH_EXECUTION_TIMEOUT, 60000);
    private boolean shouldBeHeld = false;

    public ConnectionProxyXA(Connection originalConnection, XAConnection xaConnection, BaseDataSourceResource resource, String xid) {
        super(originalConnection, xaConnection, resource, xid);
        this.shouldBeHeld = resource.isShouldBeHeld();
    }

    public void init() {
        try {
            this.xaResource = this.xaConnection.getXAResource();
            this.currentAutoCommitStatus = this.originalConnection.getAutoCommit();
            if (!this.currentAutoCommitStatus) {
                throw new IllegalStateException("Connection[autocommit=false] as default is NOT supported");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void keepIfNecessary() {
        if (this.shouldBeHeld()) {
            this.resource.hold(this.xaBranchXid.toString(), this);
        }
    }

    private void releaseIfNecessary() {
        if (this.shouldBeHeld() && this.xaBranchXid != null) {
            String xaBranchXid = this.xaBranchXid.toString();
            if (this.isHeld()) {
                this.resource.release(xaBranchXid, this);
            }
        }
    }

    private void xaEnd(XAXid xaXid, int flags) throws XAException {
        if (!this.xaEnded) {
            this.xaResource.end(xaXid, flags);
            this.xaEnded = true;
        }
    }

    public synchronized void xaCommit(String xid, long branchId, String applicationData) throws XAException {
        XAXid xaXid = XAXidBuilder.build(xid, branchId);
        this.xaResource.commit(xaXid, false);
        this.releaseIfNecessary();
    }

    public synchronized void xaRollback(String xid, long branchId, String applicationData) throws XAException {
        XAXid xaXid = XAXidBuilder.build(xid, branchId);
        this.xaRollback(xaXid);
    }

    public void xaRollback(XAXid xaXid) throws XAException {
        this.xaResource.rollback(xaXid);
        this.releaseIfNecessary();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.currentAutoCommitStatus == autoCommit) {
            return;
        }
        if (autoCommit) {
            if (this.xaActive) {
                this.commit();
            }
        } else {
            long branchId;
            if (this.xaActive) {
                throw new SQLException("should NEVER happen: setAutoCommit from true to false while xa branch is active");
            }
            try {
                this.branchRegisterTime = System.currentTimeMillis();
                branchId = DefaultResourceManager.get().branchRegister(BranchType.XA, this.resource.getResourceId(), null, this.xid, null, null);
            }
            catch (TransactionException te) {
                this.cleanXABranchContext();
                throw new SQLException("failed to register xa branch " + this.xid + " since " + (Object)((Object)te.getCode()) + ":" + te.getMessage(), te);
            }
            this.xaBranchXid = XAXidBuilder.build(this.xid, branchId);
            this.keepIfNecessary();
            try {
                this.start();
            }
            catch (XAException e) {
                this.cleanXABranchContext();
                throw new SQLException("failed to start xa branch " + this.xid + " since " + e.getMessage(), e);
            }
            this.xaActive = true;
        }
        this.currentAutoCommitStatus = autoCommit;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.currentAutoCommitStatus;
    }

    @Override
    public synchronized void commit() throws SQLException {
        if (this.currentAutoCommitStatus) {
            return;
        }
        if (!this.xaActive || this.xaBranchXid == null) {
            throw new SQLException("should NOT commit on an inactive session", "SQLSTATE_XA_NOT_END");
        }
        try {
            try {
                this.end(0x4000000);
            }
            catch (SQLException sqle) {
                String xaBranchXid = this.xaBranchXid.toString();
                this.rollback();
                throw new SQLException("Branch " + xaBranchXid + " was rollbacked on committing since " + sqle.getMessage(), "SQLSTATE_XA_NOT_END", sqle);
            }
            long now = System.currentTimeMillis();
            this.checkTimeout(now);
            this.setPrepareTime(now);
            this.xaResource.prepare(this.xaBranchXid);
        }
        catch (XAException xe) {
            this.reportStatusToTC(BranchStatus.PhaseOne_Failed);
            throw new SQLException("Failed to end(TMSUCCESS)/prepare xa branch on " + this.xid + "-" + this.xaBranchXid.getBranchId() + " since " + xe.getMessage(), xe);
        }
        finally {
            this.cleanXABranchContext();
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.currentAutoCommitStatus) {
            return;
        }
        if (!this.xaActive || this.xaBranchXid == null) {
            throw new SQLException("should NOT rollback on an inactive session");
        }
        try {
            if (!this.rollBacked) {
                this.xaEnd(this.xaBranchXid, 0x20000000);
                this.xaRollback(this.xaBranchXid);
            }
            this.reportStatusToTC(BranchStatus.PhaseOne_Failed);
            LOGGER.info("{} was rollbacked", (Object)this.xaBranchXid);
        }
        catch (XAException xe) {
            throw new SQLException("Failed to end(TMFAIL) xa branch on " + this.xid + "-" + this.xaBranchXid.getBranchId() + " since " + xe.getMessage(), xe);
        }
        finally {
            this.cleanXABranchContext();
        }
    }

    private synchronized void start() throws XAException, SQLException {
        if ("oracle".equals(this.resource.getDbType())) {
            this.xaResource.start(this.xaBranchXid, 65536);
        } else {
            this.xaResource.start(this.xaBranchXid, 0);
        }
        try {
            this.termination();
        }
        catch (SQLException e) {
            this.xaResource.end(this.xaBranchXid, 0x20000000);
            this.xaRollback(this.xaBranchXid);
            this.reportStatusToTC(BranchStatus.PhaseOne_Failed);
            throw e;
        }
    }

    private synchronized void end(int flags) throws XAException, SQLException {
        this.xaEnd(this.xaBranchXid, flags);
        this.termination();
    }

    private void cleanXABranchContext() {
        this.branchRegisterTime = null;
        this.prepareTime = null;
        this.xaActive = false;
        if (!this.isHeld()) {
            this.xaBranchXid = null;
        }
    }

    private void checkTimeout(Long now) throws XAException {
        if (now - this.branchRegisterTime > (long)TIMEOUT.intValue()) {
            this.xaRollback(this.xaBranchXid);
            throw new XAException("XA branch timeout error");
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.rollBacked = false;
        if (this.isHeld() && this.shouldBeHeld()) {
            return;
        }
        this.cleanXABranchContext();
        this.originalConnection.close();
    }

    protected synchronized void closeForce() throws SQLException {
        Connection physicalConn = this.getWrappedConnection();
        if (physicalConn instanceof PooledConnection) {
            physicalConn = ((PooledConnection)((Object)physicalConn)).getConnection();
        }
        physicalConn.close();
        this.xaEnded = false;
        this.rollBacked = false;
        this.cleanXABranchContext();
        this.originalConnection.close();
        this.releaseIfNecessary();
    }

    @Override
    public void setHeld(boolean kept) {
        this.kept = kept;
    }

    @Override
    public boolean isHeld() {
        return this.kept;
    }

    @Override
    public boolean shouldBeHeld() {
        return this.shouldBeHeld || StringUtils.isBlank(this.resource.getDbType());
    }

    public Long getPrepareTime() {
        return this.prepareTime;
    }

    private void setPrepareTime(Long prepareTime) {
        this.prepareTime = prepareTime;
    }

    private void termination() throws SQLException {
        this.termination(this.xaBranchXid.toString());
    }

    private void termination(String xaBranchXid) throws SQLException {
        BranchStatus branchStatus = BaseDataSourceResource.getBranchStatus(xaBranchXid);
        if (branchStatus != null) {
            this.releaseIfNecessary();
            throw new SQLException("failed xa branch " + this.xid + " the global transaction has finish, branch status: " + branchStatus.getCode());
        }
    }

    private void reportStatusToTC(BranchStatus status) {
        try {
            DefaultResourceManager.get().branchReport(BranchType.XA, this.xid, this.xaBranchXid.getBranchId(), status, null);
        }
        catch (TransactionException te) {
            LOGGER.warn("Failed to report XA branch {} on {}-{} since {}:{}", new Object[]{status, this.xid, this.xaBranchXid.getBranchId(), te.getCode(), te.getMessage()});
        }
    }
}

