/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.engine.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.seata.saga.engine.config.AbstractStateMachineConfig;
import org.apache.seata.saga.engine.expression.ExpressionFactoryManager;
import org.apache.seata.saga.engine.expression.spel.SpringELExpressionFactory;
import org.apache.seata.saga.engine.invoker.ServiceInvokerManager;
import org.apache.seata.saga.engine.invoker.impl.SpringBeanServiceInvoker;
import org.apache.seata.saga.engine.utils.ResourceUtil;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;

public class DefaultStateMachineConfig
extends AbstractStateMachineConfig
implements ApplicationContextAware,
InitializingBean {
    private ApplicationContext applicationContext;
    private String[] resources = new String[]{"classpath*:seata/saga/statelang/**/*.json"};

    public void afterPropertiesSet() throws Exception {
        super.init();
        this.registerStateMachineDef();
        this.registerSpringElExpressionFactoryManager();
        this.registerSpringBeanServiceInvoker();
    }

    private void registerStateMachineDef() throws IOException {
        Resource[] registerResources = ResourceUtil.getResources(this.resources);
        InputStream[] resourceAsStreamArray = new InputStream[registerResources.length];
        for (int i = 0; i < registerResources.length; ++i) {
            resourceAsStreamArray[i] = registerResources[i].getInputStream();
        }
        this.getStateMachineRepository().registryByResources(resourceAsStreamArray, this.getDefaultTenantId());
    }

    private void registerSpringElExpressionFactoryManager() {
        ExpressionFactoryManager expressionFactoryManager = this.getExpressionFactoryManager();
        SpringELExpressionFactory springELExpressionFactory = new SpringELExpressionFactory(this.getApplicationContext());
        expressionFactoryManager.putExpressionFactory("Default", springELExpressionFactory);
    }

    private void registerSpringBeanServiceInvoker() {
        ServiceInvokerManager manager = this.getServiceInvokerManager();
        SpringBeanServiceInvoker springBeanServiceInvoker = new SpringBeanServiceInvoker();
        springBeanServiceInvoker.setSagaJsonParser(this.getSagaJsonParser());
        springBeanServiceInvoker.setApplicationContext(this.getApplicationContext());
        springBeanServiceInvoker.setThreadPoolExecutor(this.getThreadPoolExecutor());
        manager.putServiceInvoker("SpringBean", springBeanServiceInvoker);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

