/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.proctrl.handler;

import java.util.Map;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.saga.proctrl.Instruction;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.ProcessRouter;
import org.apache.seata.saga.proctrl.ProcessType;
import org.apache.seata.saga.proctrl.eventing.EventPublisher;
import org.apache.seata.saga.proctrl.handler.RouterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRouterHandler
implements RouterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRouterHandler.class);
    private EventPublisher<ProcessContext> eventPublisher;
    private Map<String, ProcessRouter> processRouters;

    public static ProcessType matchProcessType(ProcessContext context) {
        ProcessType processType = (ProcessType)((Object)context.getVariable("_ProcessType_"));
        if (processType == null) {
            processType = ProcessType.STATE_LANG;
        }
        return processType;
    }

    @Override
    public void route(ProcessContext context) throws FrameworkException {
        try {
            ProcessType processType = DefaultRouterHandler.matchProcessType(context);
            if (processType == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Process type not found, context= {}", (Object)context);
                }
                throw new FrameworkException(FrameworkErrorCode.ProcessTypeNotFound);
            }
            ProcessRouter processRouter = this.processRouters.get(processType.getCode());
            if (processRouter == null) {
                LOGGER.error("Cannot find process router by type {}, context = {}", (Object)processType.getCode(), (Object)context);
                throw new FrameworkException(FrameworkErrorCode.ProcessRouterNotFound);
            }
            Instruction instruction = processRouter.route(context);
            if (instruction == null) {
                LOGGER.info("route instruction is null, process end");
            } else {
                context.setInstruction(instruction);
                this.eventPublisher.publish(context);
            }
        }
        catch (FrameworkException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new FrameworkException(ex, ex.getMessage(), FrameworkErrorCode.UnknownAppError);
        }
    }

    public void setEventPublisher(EventPublisher<ProcessContext> eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setProcessRouters(Map<String, ProcessRouter> processRouters) {
        this.processRouters = processRouters;
    }
}

