/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.proctrl.impl;

import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.common.exception.FrameworkException;
import org.apache.seata.saga.proctrl.ProcessContext;
import org.apache.seata.saga.proctrl.ProcessController;
import org.apache.seata.saga.proctrl.process.BusinessProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessControllerImpl
implements ProcessController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessControllerImpl.class);
    private BusinessProcessor businessProcessor;

    @Override
    public void process(ProcessContext context) throws FrameworkException {
        try {
            this.businessProcessor.process(context);
            this.businessProcessor.route(context);
        }
        catch (FrameworkException fex) {
            throw fex;
        }
        catch (Exception ex) {
            LOGGER.error("Unknown exception occurred, context = {}", (Object)context, (Object)ex);
            throw new FrameworkException(ex, "Unknown exception occurred", FrameworkErrorCode.UnknownAppError);
        }
    }

    public void setBusinessProcessor(BusinessProcessor businessProcessor) {
        this.businessProcessor = businessProcessor;
    }
}

