/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.rm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.exception.FrameworkErrorCode;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.model.BranchStatus;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.core.model.GlobalStatus;
import org.apache.seata.core.model.Resource;
import org.apache.seata.rm.AbstractResourceManager;
import org.apache.seata.saga.engine.exception.EngineExecutionException;
import org.apache.seata.saga.engine.exception.ForwardInvalidException;
import org.apache.seata.saga.rm.SagaResource;
import org.apache.seata.saga.rm.StateMachineEngineHolder;
import org.apache.seata.saga.statelang.domain.ExecutionStatus;
import org.apache.seata.saga.statelang.domain.RecoverStrategy;
import org.apache.seata.saga.statelang.domain.StateMachineInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaResourceManager
extends AbstractResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SagaResourceManager.class);
    private Map<String, Resource> sagaResourceCache = new ConcurrentHashMap<String, Resource>();

    @Override
    public void registerResource(Resource resource) {
        SagaResource sagaResource = (SagaResource)resource;
        this.sagaResourceCache.put(sagaResource.getResourceId(), sagaResource);
        super.registerResource(sagaResource);
    }

    @Override
    public Map<String, Resource> getManagedResources() {
        return this.sagaResourceCache;
    }

    @Override
    public BranchStatus branchCommit(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        try {
            StateMachineInstance machineInstance = StateMachineEngineHolder.getStateMachineEngine().forward(xid, null);
            if (ExecutionStatus.SU.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null) {
                return BranchStatus.PhaseTwo_Committed;
            }
            if (ExecutionStatus.SU.equals((Object)machineInstance.getCompensationStatus())) {
                return BranchStatus.PhaseTwo_Rollbacked;
            }
            if (ExecutionStatus.FA.equals((Object)machineInstance.getCompensationStatus()) || ExecutionStatus.UN.equals((Object)machineInstance.getCompensationStatus())) {
                return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
            }
            if (ExecutionStatus.FA.equals((Object)machineInstance.getStatus()) && machineInstance.getCompensationStatus() == null) {
                return BranchStatus.PhaseOne_Failed;
            }
        }
        catch (ForwardInvalidException e) {
            LOGGER.error("StateMachine forward failed, xid: " + xid, (Throwable)e);
            if (FrameworkErrorCode.StateMachineInstanceNotExists.equals((Object)e.getErrcode())) {
                return BranchStatus.PhaseTwo_Committed;
            }
        }
        catch (Exception e) {
            LOGGER.error("StateMachine forward failed, xid: " + xid, (Throwable)e);
        }
        return BranchStatus.PhaseTwo_CommitFailed_Retryable;
    }

    @Override
    public BranchStatus branchRollback(BranchType branchType, String xid, long branchId, String resourceId, String applicationData) throws TransactionException {
        try {
            StateMachineInstance stateMachineInstance = StateMachineEngineHolder.getStateMachineEngine().reloadStateMachineInstance(xid);
            if (stateMachineInstance == null) {
                return BranchStatus.PhaseTwo_Rollbacked;
            }
            if (RecoverStrategy.Forward.equals((Object)stateMachineInstance.getStateMachine().getRecoverStrategy()) && (GlobalStatus.TimeoutRollbacking.name().equals(applicationData) || GlobalStatus.TimeoutRollbackRetrying.name().equals(applicationData))) {
                LOGGER.warn("Retry by custom recover strategy [Forward] on timeout, SAGA global[{}]", (Object)xid);
                return BranchStatus.PhaseTwo_CommitFailed_Retryable;
            }
            stateMachineInstance = StateMachineEngineHolder.getStateMachineEngine().compensate(xid, null);
            if (ExecutionStatus.SU.equals((Object)stateMachineInstance.getCompensationStatus())) {
                return BranchStatus.PhaseTwo_Rollbacked;
            }
        }
        catch (EngineExecutionException e) {
            LOGGER.error("StateMachine compensate failed, xid: " + xid, (Throwable)e);
            if (FrameworkErrorCode.StateMachineInstanceNotExists.equals((Object)e.getErrcode())) {
                return BranchStatus.PhaseTwo_Rollbacked;
            }
        }
        catch (Exception e) {
            LOGGER.error("StateMachine compensate failed, xid: " + xid, (Throwable)e);
        }
        return BranchStatus.PhaseTwo_RollbackFailed_Retryable;
    }

    @Override
    public BranchType getBranchType() {
        return BranchType.SAGA;
    }
}

