/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.saga.statelang.parser;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.saga.statelang.parser.StateParser;
import org.apache.seata.saga.statelang.parser.impl.ChoiceStateParser;
import org.apache.seata.saga.statelang.parser.impl.CompensateSubStateMachineStateParser;
import org.apache.seata.saga.statelang.parser.impl.CompensationTriggerStateParser;
import org.apache.seata.saga.statelang.parser.impl.FailEndStateParser;
import org.apache.seata.saga.statelang.parser.impl.ScriptTaskStateParser;
import org.apache.seata.saga.statelang.parser.impl.ServiceTaskStateParser;
import org.apache.seata.saga.statelang.parser.impl.SubStateMachineParser;
import org.apache.seata.saga.statelang.parser.impl.SucceedEndStateParser;

public class StateParserFactory {
    protected static Map<String, StateParser> stateParserMap = new ConcurrentHashMap<String, StateParser>();

    public static StateParser getStateParser(String stateType) {
        return stateParserMap.get(stateType);
    }

    static {
        stateParserMap.put("ServiceTask", new ServiceTaskStateParser());
        stateParserMap.put("Choice", new ChoiceStateParser());
        stateParserMap.put("CompensationTrigger", new CompensationTriggerStateParser());
        stateParserMap.put("Fail", new FailEndStateParser());
        stateParserMap.put("Succeed", new SucceedEndStateParser());
        stateParserMap.put("SubStateMachine", new SubStateMachineParser());
        stateParserMap.put("CompensateSubMachine", new CompensateSubStateMachineStateParser());
        stateParserMap.put("ScriptTask", new ScriptTaskStateParser());
    }
}

