/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.serializer.seata.protocol;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.ResultCode;
import org.apache.seata.serializer.seata.protocol.AbstractMessageCodec;

public abstract class AbstractResultMessageCodec
extends AbstractMessageCodec {
    @Override
    public Class<?> getMessageClassType() {
        return AbstractResultMessage.class;
    }

    @Override
    public <T> void encode(T t, ByteBuf out) {
        AbstractResultMessage abstractResultMessage = (AbstractResultMessage)t;
        ResultCode resultCode = abstractResultMessage.getResultCode();
        String resultMsg = abstractResultMessage.getMsg();
        out.writeByte(resultCode.ordinal());
        if (resultCode == ResultCode.Failed) {
            if (StringUtils.isNotEmpty(resultMsg)) {
                String msg = resultMsg.length() > Short.MAX_VALUE ? resultMsg.substring(0, Short.MAX_VALUE) : resultMsg;
                byte[] bs = msg.getBytes(UTF8);
                out.writeShort((int)((short)bs.length));
                out.writeBytes(bs);
            } else {
                out.writeShort(0);
            }
        }
    }

    @Override
    public <T> void decode(T t, ByteBuffer in) {
        short len;
        AbstractResultMessage abstractResultMessage = (AbstractResultMessage)t;
        ResultCode resultCode = ResultCode.get(in.get());
        abstractResultMessage.setResultCode(resultCode);
        if (resultCode == ResultCode.Failed && (len = in.getShort()) > 0) {
            byte[] msg = new byte[len];
            in.get(msg);
            abstractResultMessage.setMsg(new String(msg, UTF8));
        }
    }
}

