/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.sqlparser.druid.sqlserver;

import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprHint;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.druid.SQLOperateRecognizerHolder;
import org.apache.seata.sqlparser.druid.sqlserver.SqlServerDeleteRecognizer;
import org.apache.seata.sqlparser.druid.sqlserver.SqlServerInsertRecognizer;
import org.apache.seata.sqlparser.druid.sqlserver.SqlServerSelectForUpdateRecognizer;
import org.apache.seata.sqlparser.druid.sqlserver.SqlServerUpdateRecognizer;

@LoadLevel(name="sqlserver")
public class SqlServerOperateRecognizerHolder
implements SQLOperateRecognizerHolder {
    @Override
    public SQLRecognizer getDeleteRecognizer(String sql, SQLStatement ast) {
        return new SqlServerDeleteRecognizer(sql, ast);
    }

    @Override
    public SQLRecognizer getInsertRecognizer(String sql, SQLStatement ast) {
        return new SqlServerInsertRecognizer(sql, ast);
    }

    @Override
    public SQLRecognizer getUpdateRecognizer(String sql, SQLStatement ast) {
        return new SqlServerUpdateRecognizer(sql, ast);
    }

    @Override
    public SQLRecognizer getSelectForUpdateRecognizer(String sql, SQLStatement ast) {
        List hintsTexts;
        List hints = ((SQLSelectStatement)ast).getSelect().getQueryBlock().getFrom().getHints();
        if (CollectionUtils.isNotEmpty(hints) && (hintsTexts = hints.stream().map(hint -> {
            if (hint instanceof SQLExprHint) {
                SQLExpr expr = ((SQLExprHint)hint).getExpr();
                return expr instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)expr).getName() : "";
            }
            if (hint instanceof SQLCommentHint) {
                return ((SQLCommentHint)hint).getText();
            }
            return "";
        }).collect(Collectors.toList())).contains("UPDLOCK")) {
            return new SqlServerSelectForUpdateRecognizer(sql, ast);
        }
        return null;
    }
}

