/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.store;

public enum LockMode {
    FILE("file"),
    DB("db"),
    REDIS("redis"),
    RAFT("raft");

    private String name;

    private LockMode(String name) {
        this.name = name;
    }

    public static LockMode get(String name) {
        for (LockMode mode : LockMode.values()) {
            if (!mode.getName().equalsIgnoreCase(name)) continue;
            return mode;
        }
        throw new IllegalArgumentException("unknown lock mode:" + name);
    }

    public static boolean contains(String name) {
        try {
            return LockMode.get(name) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }
}

