/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.seata.common.loader.LoadLevel;
import org.apache.seata.common.loader.Scope;
import org.apache.seata.config.file.FileConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

@LoadLevel(name="YAML", order=1, scope=Scope.PROTOTYPE)
public class YamlFileConfig
implements FileConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlFileConfig.class);
    private final Map<String, Object> configMap = new HashMap<String, Object>();

    public YamlFileConfig(File file, String name) throws IOException {
        Yaml yaml = new Yaml();
        try (FileInputStream is = new FileInputStream(file);){
            this.flattenConfig("", (Map)yaml.loadAs((InputStream)is, HashMap.class), this.configMap);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("file not found");
        }
    }

    private void flattenConfig(String prefix, Map<String, Object> config, Map<String, Object> flatMap) {
        for (Map.Entry<String, Object> entry : config.entrySet()) {
            String key;
            String string = key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Map) {
                this.flattenConfig(key, (Map)value, flatMap);
                continue;
            }
            flatMap.put(key, String.valueOf(value));
        }
    }

    @Override
    public String getString(String path) {
        try {
            Object value = this.configMap.get(path);
            return value == null ? null : String.valueOf(value);
        }
        catch (Exception e) {
            LOGGER.warn("get config data error" + path, (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> getAllConfig() {
        return this.configMap;
    }
}

