/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.tx.api.interceptor.handler;

import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.CachedConfigurationChangeListener;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.event.EventBus;
import org.apache.seata.core.event.GuavaEventBus;
import org.apache.seata.core.exception.TmTransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.GlobalLockConfig;
import org.apache.seata.integration.tx.api.annotation.AspectTransactional;
import org.apache.seata.integration.tx.api.event.DegradeCheckEvent;
import org.apache.seata.integration.tx.api.interceptor.InvocationHandlerType;
import org.apache.seata.integration.tx.api.interceptor.InvocationWrapper;
import org.apache.seata.integration.tx.api.interceptor.SeataInterceptorPosition;
import org.apache.seata.integration.tx.api.interceptor.handler.AbstractProxyInvocationHandler;
import org.apache.seata.integration.tx.api.util.ClassUtils;
import org.apache.seata.rm.GlobalLockExecutor;
import org.apache.seata.rm.GlobalLockTemplate;
import org.apache.seata.spring.annotation.GlobalLock;
import org.apache.seata.spring.annotation.GlobalTransactional;
import org.apache.seata.tm.TransactionManagerHolder;
import org.apache.seata.tm.api.FailureHandler;
import org.apache.seata.tm.api.FailureHandlerHolder;
import org.apache.seata.tm.api.GlobalTransaction;
import org.apache.seata.tm.api.GlobalTransactionRole;
import org.apache.seata.tm.api.TransactionalExecutor;
import org.apache.seata.tm.api.TransactionalTemplate;
import org.apache.seata.tm.api.transaction.NoRollbackRule;
import org.apache.seata.tm.api.transaction.RollbackRule;
import org.apache.seata.tm.api.transaction.TransactionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalTransactionalInterceptorHandler
extends AbstractProxyInvocationHandler
implements CachedConfigurationChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalTransactionalInterceptorHandler.class);
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final GlobalLockTemplate globalLockTemplate = new GlobalLockTemplate();
    private Set<String> methodsToProxy;
    private volatile boolean disable;
    private static final AtomicBoolean ATOMIC_DEGRADE_CHECK = new AtomicBoolean(false);
    private static volatile Integer degradeNum = 0;
    private static volatile Integer reachNum = 0;
    private static int degradeCheckAllowTimes;
    protected AspectTransactional aspectTransactional;
    private static int degradeCheckPeriod;
    private static int defaultGlobalTransactionTimeout;
    private final FailureHandler failureHandler;
    private static final EventBus EVENT_BUS;
    private static volatile ScheduledThreadPoolExecutor executor;

    private void initDefaultGlobalTransactionTimeout() {
        if (defaultGlobalTransactionTimeout <= 0) {
            int defaultGlobalTransactionTimeout;
            try {
                defaultGlobalTransactionTimeout = ConfigurationFactory.getInstance().getInt("client.tm.defaultGlobalTransactionTimeout", 60000);
            }
            catch (Exception e) {
                LOGGER.error("Illegal global transaction timeout value: " + e.getMessage());
                defaultGlobalTransactionTimeout = 60000;
            }
            if (defaultGlobalTransactionTimeout <= 0) {
                LOGGER.warn("Global transaction timeout value '{}' is illegal, and has been reset to the default value '{}'", (Object)defaultGlobalTransactionTimeout, (Object)60000);
                defaultGlobalTransactionTimeout = 60000;
            }
            GlobalTransactionalInterceptorHandler.defaultGlobalTransactionTimeout = defaultGlobalTransactionTimeout;
        }
    }

    public GlobalTransactionalInterceptorHandler(FailureHandler failureHandler, Set<String> methodsToProxy) {
        this.failureHandler = failureHandler == null ? FailureHandlerHolder.getFailureHandler() : failureHandler;
        this.methodsToProxy = methodsToProxy;
        Configuration configuration = ConfigurationFactory.getInstance();
        this.disable = configuration.getBoolean("service.disableGlobalTransaction", false);
        boolean degradeCheck = configuration.getBoolean("client.tm.degradeCheck", false);
        degradeCheckPeriod = configuration.getInt("client.tm.degradeCheckPeriod", 2000);
        degradeCheckAllowTimes = configuration.getInt("client.tm.degradeCheckAllowTimes", 10);
        EVENT_BUS.register(this);
        if (degradeCheck && degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
            GlobalTransactionalInterceptorHandler.startDegradeCheck();
        }
        configuration.addConfigListener("client.tm.degradeCheck", this);
        this.initDefaultGlobalTransactionTimeout();
    }

    public GlobalTransactionalInterceptorHandler(FailureHandler failureHandler, Set<String> methodsToProxy, AspectTransactional aspectTransactional) {
        this(failureHandler, methodsToProxy);
        this.aspectTransactional = aspectTransactional;
    }

    @Override
    protected Object doInvoke(InvocationWrapper invocation) throws Throwable {
        Class<?> targetClass = invocation.getTarget().getClass();
        Method specificMethod = ClassUtils.getMostSpecificMethod(invocation.getMethod(), targetClass);
        if (specificMethod != null && !specificMethod.getDeclaringClass().equals(Object.class)) {
            boolean localDisable;
            boolean bl = localDisable = this.disable || ATOMIC_DEGRADE_CHECK.get() && degradeNum >= degradeCheckAllowTimes;
            if (!localDisable) {
                AspectTransactional globalTransactionalAnnotation = this.getAspectTransactional(specificMethod, targetClass);
                GlobalLockConfig globalLockAnnotation = this.getGlobalLockConfig(specificMethod, targetClass);
                if (globalTransactionalAnnotation != null || this.aspectTransactional != null) {
                    AspectTransactional transactional = globalTransactionalAnnotation != null ? globalTransactionalAnnotation : this.aspectTransactional;
                    return this.handleGlobalTransaction(invocation, transactional);
                }
                if (globalLockAnnotation != null) {
                    return this.handleGlobalLock(invocation, globalLockAnnotation);
                }
            }
        }
        return invocation.proceed();
    }

    private Object handleGlobalLock(final InvocationWrapper methodInvocation, final GlobalLockConfig globalLockConfig) throws Throwable {
        return this.globalLockTemplate.execute(new GlobalLockExecutor(){

            @Override
            public Object execute() throws Throwable {
                return methodInvocation.proceed();
            }

            @Override
            public GlobalLockConfig getGlobalLockConfig() {
                return globalLockConfig;
            }
        });
    }

    Object handleGlobalTransaction(final InvocationWrapper methodInvocation, final AspectTransactional aspectTransactional) throws Throwable {
        boolean succeed = true;
        try {
            Object object = this.transactionalTemplate.execute(new TransactionalExecutor(){

                @Override
                public Object execute() throws Throwable {
                    return methodInvocation.proceed();
                }

                public String name() {
                    String name = aspectTransactional.getName();
                    if (!StringUtils.isNullOrEmpty(name)) {
                        return name;
                    }
                    return GlobalTransactionalInterceptorHandler.this.formatMethod(methodInvocation.getMethod());
                }

                @Override
                public TransactionInfo getTransactionInfo() {
                    int timeout = aspectTransactional.getTimeoutMills();
                    if (timeout <= 0 || timeout == 60000) {
                        timeout = defaultGlobalTransactionTimeout;
                    }
                    TransactionInfo transactionInfo = new TransactionInfo();
                    transactionInfo.setTimeOut(timeout);
                    transactionInfo.setName(this.name());
                    transactionInfo.setPropagation(aspectTransactional.getPropagation());
                    transactionInfo.setLockRetryInterval(aspectTransactional.getLockRetryInterval());
                    transactionInfo.setLockRetryTimes(aspectTransactional.getLockRetryTimes());
                    transactionInfo.setLockStrategyMode(aspectTransactional.getLockStrategyMode());
                    LinkedHashSet<RollbackRule> rollbackRules = new LinkedHashSet<RollbackRule>();
                    for (Class<? extends Throwable> clazz : aspectTransactional.getRollbackFor()) {
                        rollbackRules.add(new RollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getRollbackForClassName()) {
                        rollbackRules.add(new RollbackRule(string));
                    }
                    for (Class<? extends Throwable> clazz : aspectTransactional.getNoRollbackFor()) {
                        rollbackRules.add(new NoRollbackRule(clazz));
                    }
                    for (String string : aspectTransactional.getNoRollbackForClassName()) {
                        rollbackRules.add(new NoRollbackRule(string));
                    }
                    transactionInfo.setRollbackRules(rollbackRules);
                    return transactionInfo;
                }
            });
            return object;
        }
        catch (TransactionalExecutor.ExecutionException e) {
            GlobalTransaction globalTransaction = e.getTransaction();
            if (globalTransaction.getGlobalTransactionRole() == GlobalTransactionRole.Participant) {
                throw e.getOriginalException();
            }
            TransactionalExecutor.Code code = e.getCode();
            Throwable cause = e.getCause();
            boolean timeout = this.isTimeoutException(cause);
            switch (code) {
                case RollbackDone: {
                    if (timeout) {
                        throw cause;
                    }
                    throw e.getOriginalException();
                }
                case BeginFailure: {
                    succeed = false;
                    this.failureHandler.onBeginFailure(globalTransaction, cause);
                    throw cause;
                }
                case CommitFailure: {
                    succeed = false;
                    this.failureHandler.onCommitFailure(globalTransaction, cause);
                    throw cause;
                }
                case RollbackFailure: {
                    this.failureHandler.onRollbackFailure(globalTransaction, e.getOriginalException());
                    throw e.getOriginalException();
                }
                case Rollbacking: {
                    this.failureHandler.onRollbacking(globalTransaction, e.getOriginalException());
                    if (timeout) {
                        throw cause;
                    }
                    throw e.getOriginalException();
                }
            }
            throw new ShouldNeverHappenException(String.format("Unknown TransactionalExecutor.Code: %s", new Object[]{code}), e.getOriginalException());
        }
        finally {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                EVENT_BUS.post(new DegradeCheckEvent(succeed));
            }
        }
    }

    public GlobalLockConfig getGlobalLockConfig(Method method, Class<?> targetClass) {
        GlobalLock globalLockAnno = this.getAnnotation(method, targetClass, GlobalLock.class);
        if (globalLockAnno != null) {
            GlobalLockConfig config = new GlobalLockConfig();
            config.setLockRetryInterval(globalLockAnno.lockRetryInterval());
            config.setLockRetryTimes(globalLockAnno.lockRetryTimes());
            return config;
        }
        return null;
    }

    public AspectTransactional getAspectTransactional(Method method, Class<?> targetClass) {
        GlobalTransactional globalTransactionalAnnotation = this.getAnnotation(method, targetClass, GlobalTransactional.class);
        return globalTransactionalAnnotation != null ? new AspectTransactional(globalTransactionalAnnotation.timeoutMills(), globalTransactionalAnnotation.name(), globalTransactionalAnnotation.rollbackFor(), globalTransactionalAnnotation.rollbackForClassName(), globalTransactionalAnnotation.noRollbackFor(), globalTransactionalAnnotation.noRollbackForClassName(), globalTransactionalAnnotation.propagation(), globalTransactionalAnnotation.lockRetryInterval(), globalTransactionalAnnotation.lockRetryTimes(), globalTransactionalAnnotation.lockStrategyMode()) : null;
    }

    private String formatMethod(Method method) {
        StringBuilder sb = new StringBuilder(method.getName()).append("(");
        Class<?>[] params = method.getParameterTypes();
        int in = 0;
        for (Class<?> clazz : params) {
            sb.append(clazz.getName());
            if (++in >= params.length) continue;
            sb.append(", ");
        }
        return sb.append(")").toString();
    }

    @Override
    public void onChangeEvent(ConfigurationChangeEvent event) {
        if ("service.disableGlobalTransaction".equals(event.getDataId())) {
            LOGGER.info("{} config changed, old value:{}, new value:{}", new Object[]{"service.disableGlobalTransaction", this.disable, event.getNewValue()});
            this.disable = Boolean.parseBoolean(event.getNewValue().trim());
        } else if ("client.tm.degradeCheck".equals(event.getDataId())) {
            boolean degradeCheck = Boolean.parseBoolean(event.getNewValue());
            if (!degradeCheck) {
                degradeNum = 0;
                GlobalTransactionalInterceptorHandler.stopDegradeCheck();
            } else if (degradeCheckPeriod > 0 && degradeCheckAllowTimes > 0) {
                GlobalTransactionalInterceptorHandler.startDegradeCheck();
            }
        }
    }

    private static void stopDegradeCheck() {
        if (!ATOMIC_DEGRADE_CHECK.compareAndSet(true, false)) {
            return;
        }
        if (executor != null && !executor.isShutdown()) {
            executor.shutdown();
        }
    }

    private static void startDegradeCheck() {
        if (!ATOMIC_DEGRADE_CHECK.compareAndSet(false, true)) {
            return;
        }
        if (executor != null && !executor.isShutdown()) {
            return;
        }
        executor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("degradeCheckWorker", 1, true));
        executor.scheduleAtFixedRate(() -> {
            if (ATOMIC_DEGRADE_CHECK.get()) {
                try {
                    String xid = TransactionManagerHolder.get().begin(null, null, "degradeCheck", 60000);
                    TransactionManagerHolder.get().commit(xid);
                    EVENT_BUS.post(new DegradeCheckEvent(true));
                }
                catch (Exception e) {
                    EVENT_BUS.post(new DegradeCheckEvent(false));
                }
            }
        }, degradeCheckPeriod, degradeCheckPeriod, TimeUnit.MILLISECONDS);
    }

    @Subscribe
    public static void onDegradeCheck(DegradeCheckEvent event) {
        if (event.isRequestSuccess()) {
            if (degradeNum >= degradeCheckAllowTimes) {
                Integer n = reachNum;
                Integer n2 = reachNum = Integer.valueOf(reachNum + 1);
                if (reachNum >= degradeCheckAllowTimes) {
                    reachNum = 0;
                    degradeNum = 0;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("the current global transaction has been restored");
                    }
                }
            } else if (degradeNum != 0) {
                degradeNum = 0;
            }
        } else if (degradeNum < degradeCheckAllowTimes) {
            Integer n = degradeNum;
            Integer n3 = degradeNum = Integer.valueOf(degradeNum + 1);
            if (degradeNum >= degradeCheckAllowTimes && LOGGER.isWarnEnabled()) {
                LOGGER.warn("the current global transaction has been automatically downgraded");
            }
        } else if (reachNum != 0) {
            reachNum = 0;
        }
    }

    private boolean isTimeoutException(Throwable th) {
        TmTransactionException exx;
        if (null == th) {
            return false;
        }
        return th instanceof TmTransactionException && TransactionExceptionCode.TransactionTimeout == (exx = (TmTransactionException)th).getCode();
    }

    @Override
    public Set<String> getMethodsToProxy() {
        return this.methodsToProxy;
    }

    @Override
    public SeataInterceptorPosition getPosition() {
        return SeataInterceptorPosition.BeforeTransaction;
    }

    @Override
    public String type() {
        return InvocationHandlerType.GlobalTransactional.name();
    }

    static {
        defaultGlobalTransactionTimeout = 0;
        EVENT_BUS = new GuavaEventBus("degradeCheckEventBus", true);
    }
}

