/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.exec;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.rm.datasource.StatementProxy;
import org.apache.seata.rm.datasource.exec.BaseTransactionalExecutor;
import org.apache.seata.rm.datasource.exec.LockConflictException;
import org.apache.seata.rm.datasource.exec.LockRetryController;
import org.apache.seata.rm.datasource.exec.StatementCallback;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.sqlparser.SQLRecognizer;
import org.apache.seata.sqlparser.SQLSelectRecognizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectForUpdateExecutor<T, S extends Statement>
extends BaseTransactionalExecutor<T, S> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectForUpdateExecutor.class);

    public SelectForUpdateExecutor(StatementProxy<S> statementProxy, StatementCallback<T, S> statementCallback, SQLRecognizer sqlRecognizer) {
        super(statementProxy, statementCallback, sqlRecognizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T doExecute(Object ... args) throws Throwable {
        Object rs;
        Connection conn = this.statementProxy.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        Savepoint sp = null;
        boolean originalAutoCommit = conn.getAutoCommit();
        try {
            if (originalAutoCommit) {
                conn.setAutoCommit(false);
            } else if (dbmd.supportsSavepoints()) {
                sp = conn.setSavepoint();
            } else {
                throw new SQLException("not support savepoint. please check your db version");
            }
            LockRetryController lockRetryController = new LockRetryController();
            ArrayList<List<Object>> paramAppenderList = new ArrayList<List<Object>>();
            String selectPKSQL = this.buildSelectSQL(paramAppenderList);
            while (true) {
                try {
                    rs = this.statementCallback.execute(this.statementProxy.getTargetStatement(), args);
                    TableRecords selectPKRows = this.buildTableRecords(this.getTableMeta(), selectPKSQL, paramAppenderList);
                    String lockKeys = this.buildLockKey(selectPKRows);
                    if (StringUtils.isNullOrEmpty(lockKeys)) {
                        break;
                    }
                    if (RootContext.inGlobalTransaction() || RootContext.requireGlobalLock()) {
                        this.statementProxy.getConnectionProxy().checkLock(lockKeys);
                        break;
                    }
                    throw new RuntimeException("Unknown situation!");
                }
                catch (LockConflictException lce) {
                    if (sp != null) {
                        conn.rollback(sp);
                    } else {
                        conn.rollback();
                    }
                    lockRetryController.sleep(lce);
                    continue;
                }
                break;
            }
        }
        finally {
            if (sp != null) {
                try {
                    if (!"oracle".equalsIgnoreCase(this.getDbType())) {
                        conn.releaseSavepoint(sp);
                    }
                }
                catch (SQLException e) {
                    LOGGER.error("{} release save point error.", (Object)this.getDbType(), (Object)e);
                }
            }
            if (originalAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        return rs;
    }

    protected String buildSelectSQL(ArrayList<List<Object>> paramAppenderList) {
        SQLSelectRecognizer recognizer = (SQLSelectRecognizer)this.sqlRecognizer;
        StringBuilder selectSQLAppender = new StringBuilder("SELECT ");
        selectSQLAppender.append(this.getColumnNamesInSQL(this.getTableMeta().getEscapePkNameList(this.getDbType())));
        selectSQLAppender.append(" FROM ").append(this.getFromTableInSQL());
        String whereCondition = this.buildWhereCondition(recognizer, paramAppenderList);
        String orderByCondition = this.buildOrderCondition(recognizer, paramAppenderList);
        String limitCondition = this.buildLimitCondition(recognizer, paramAppenderList);
        if (StringUtils.isNotBlank(whereCondition)) {
            selectSQLAppender.append(" WHERE ").append(whereCondition);
        }
        if (StringUtils.isNotBlank(orderByCondition)) {
            selectSQLAppender.append(" ").append(orderByCondition);
        }
        if (StringUtils.isNotBlank(limitCondition)) {
            selectSQLAppender.append(" ").append(limitCondition);
        }
        selectSQLAppender.append(" FOR UPDATE");
        return selectSQLAppender.toString();
    }
}

