/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.sql.struct;

import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.rm.datasource.ConnectionProxy;
import org.apache.seata.rm.datasource.DataSourceProxy;
import org.apache.seata.sqlparser.struct.TableMetaCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetaCacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableMetaCacheFactory.class);
    private static final Map<String, TableMetaCache> TABLE_META_CACHE_MAP = new ConcurrentHashMap<String, TableMetaCache>();
    private static final Map<String, TableMetaRefreshHolder> TABLE_META_REFRESH_HOLDER_MAP = new ConcurrentHashMap<String, TableMetaRefreshHolder>();
    private static final long TABLE_META_REFRESH_INTERVAL_TIME = 1000L;
    private static final int MAX_QUEUE_SIZE = 2000;
    private static boolean ENABLE_TABLE_META_CHECKER_ENABLE = ConfigurationFactory.getInstance().getBoolean("client.rm.tableMetaCheckEnable", true);
    private static final long TABLE_META_CHECKER_INTERVAL = ConfigurationFactory.getInstance().getLong("client.rm.tableMetaCheckerInterval", 60000L);

    public static TableMetaCache getTableMetaCache(String dbType) {
        return CollectionUtils.computeIfAbsent(TABLE_META_CACHE_MAP, dbType, key -> EnhancedServiceLoader.load(TableMetaCache.class, dbType));
    }

    public static void registerTableMeta(DataSourceProxy dataSourceProxy) {
        TableMetaRefreshHolder holder = new TableMetaRefreshHolder(dataSourceProxy);
        TABLE_META_REFRESH_HOLDER_MAP.put(dataSourceProxy.getResourceId(), holder);
    }

    public static void tableMetaRefreshEvent(String resourceId) {
        TableMetaRefreshHolder refreshHolder = TABLE_META_REFRESH_HOLDER_MAP.get(resourceId);
        boolean offer = refreshHolder.tableMetaRefreshQueue.offer(System.nanoTime());
        if (!offer) {
            LOGGER.error("table refresh event offer error:{}", (Object)resourceId);
        }
    }

    private static void removeHolderFromMap(String resourceId) {
        TABLE_META_REFRESH_HOLDER_MAP.remove(resourceId);
        LOGGER.info("Removed TableMetaRefreshHolder for resourceId: {}", (Object)resourceId);
    }

    static class TableMetaRefreshHolder {
        private long lastRefreshFinishTime;
        private DataSourceProxy dataSource;
        private BlockingQueue<Long> tableMetaRefreshQueue;
        private final Executor tableMetaRefreshExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("tableMetaRefresh", 1, true));

        TableMetaRefreshHolder(DataSourceProxy dataSource) {
            this.dataSource = dataSource;
            this.lastRefreshFinishTime = System.nanoTime() - TimeUnit.MILLISECONDS.toNanos(1000L);
            this.tableMetaRefreshQueue = new LinkedBlockingQueue<Long>(2000);
            this.tableMetaRefreshExecutor.execute(() -> {
                while (true) {
                    if (ENABLE_TABLE_META_CHECKER_ENABLE && System.nanoTime() - this.lastRefreshFinishTime > TimeUnit.MILLISECONDS.toNanos(TABLE_META_CHECKER_INTERVAL)) {
                        TableMetaCacheFactory.tableMetaRefreshEvent(dataSource.getResourceId());
                    }
                    try {
                        Long eventTime = this.tableMetaRefreshQueue.poll(1000L, TimeUnit.MILLISECONDS);
                        if (eventTime == null || eventTime - this.lastRefreshFinishTime <= TimeUnit.MILLISECONDS.toNanos(1000L)) continue;
                        try (ConnectionProxy connection = dataSource.getConnection();){
                            TableMetaCache tableMetaCache = TableMetaCacheFactory.getTableMetaCache(dataSource.getDbType());
                            tableMetaCache.refresh(connection, dataSource.getResourceId());
                        }
                        this.lastRefreshFinishTime = System.nanoTime();
                        continue;
                    }
                    catch (SQLException ex) {
                        if (this.isDataSourceClosedException(ex)) {
                            LOGGER.info("DataSource is closed, exiting refresh task for resourceId: {}", (Object)dataSource.getResourceId());
                            TableMetaCacheFactory.removeHolderFromMap(dataSource.getResourceId());
                            return;
                        }
                        LOGGER.error("Table refresh SQL error: {}", (Object)ex.getMessage(), (Object)ex);
                        this.lastRefreshFinishTime = System.nanoTime();
                        continue;
                    }
                    catch (Exception exx) {
                        LOGGER.error("table refresh error:{}", (Object)exx.getMessage(), (Object)exx);
                        this.lastRefreshFinishTime = System.nanoTime();
                        continue;
                    }
                    break;
                }
            });
        }

        private boolean isDataSourceClosedException(SQLException ex) {
            String message = ex.getMessage().toLowerCase();
            String sqlState = ex.getSQLState();
            if ("08006".equals(sqlState)) {
                return true;
            }
            return StringUtils.isNotBlank(message) && message.contains("datasource") && message.contains("close");
        }
    }
}

