/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.undo.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.ShouldNeverHappenException;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.Row;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.AbstractUndoExecutor;
import org.apache.seata.rm.datasource.undo.SQLUndoLog;
import org.apache.seata.sqlparser.util.ColumnUtils;

public class OracleUndoDeleteExecutor
extends AbstractUndoExecutor {
    private static final String INSERT_SQL_TEMPLATE = "INSERT INTO %s (%s) VALUES (%s)";

    public OracleUndoDeleteExecutor(SQLUndoLog sqlUndoLog) {
        super(sqlUndoLog);
    }

    @Override
    protected String buildUndoSQL() {
        TableRecords beforeImage = this.sqlUndoLog.getBeforeImage();
        List<Row> beforeImageRows = beforeImage.getRows();
        if (CollectionUtils.isEmpty(beforeImageRows)) {
            throw new ShouldNeverHappenException("Invalid UNDO LOG");
        }
        Row row = beforeImageRows.get(0);
        ArrayList<Field> fields = new ArrayList<Field>(row.nonPrimaryKeys());
        fields.addAll(this.getOrderedPkList(beforeImage, row, "oracle"));
        String insertColumns = fields.stream().map(field -> ColumnUtils.addEscape(field.getName(), "oracle")).collect(Collectors.joining(", "));
        String insertValues = fields.stream().map(field -> "?").collect(Collectors.joining(", "));
        return String.format(INSERT_SQL_TEMPLATE, this.sqlUndoLog.getTableName(), insertColumns, insertValues);
    }

    @Override
    protected TableRecords getUndoRows() {
        return this.sqlUndoLog.getBeforeImage();
    }
}

