/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource.xa;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.rm.BaseDataSourceResource;
import org.apache.seata.rm.datasource.xa.PreparedStatementProxyXA;
import org.apache.seata.rm.datasource.xa.StatementProxyXA;

public abstract class AbstractConnectionProxyXA
implements Connection {
    public static final String SQLSTATE_XA_NOT_END = "SQLSTATE_XA_NOT_END";
    protected Connection originalConnection;
    protected XAConnection xaConnection;
    protected XAResource xaResource;
    protected BaseDataSourceResource resource;
    protected String xid;

    public AbstractConnectionProxyXA(Connection originalConnection, XAConnection xaConnection, BaseDataSourceResource resource, String xid) {
        this.originalConnection = originalConnection;
        this.xaConnection = xaConnection;
        this.resource = resource;
        this.xid = xid;
    }

    public XAConnection getWrappedXAConnection() {
        return this.xaConnection;
    }

    public Connection getWrappedConnection() {
        return this.originalConnection;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement targetStatement = this.originalConnection.createStatement();
        return new StatementProxyXA(this, targetStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement targetStatement = this.originalConnection.prepareStatement(sql);
        return new PreparedStatementProxyXA(this, targetStatement);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        RootContext.assertNotInGlobalTransaction();
        return this.originalConnection.prepareCall(sql);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.originalConnection.nativeSQL(sql);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.originalConnection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.originalConnection.getMetaData();
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.originalConnection.setReadOnly(readOnly);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.originalConnection.isReadOnly();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.originalConnection.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.originalConnection.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.originalConnection.setTransactionIsolation(level);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.originalConnection.getTransactionIsolation();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.originalConnection.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.originalConnection.clearWarnings();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.originalConnection.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.originalConnection.setTypeMap(map);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.originalConnection.setHoldability(holdability);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.originalConnection.getHoldability();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.originalConnection.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.originalConnection.setSavepoint(name);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.originalConnection.rollback(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.originalConnection.releaseSavepoint(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = this.originalConnection.createStatement(resultSetType, resultSetConcurrency);
        return new StatementProxyXA(this, statement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement preparedStatement = this.originalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        return new PreparedStatementProxyXA(this, preparedStatement);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        RootContext.assertNotInGlobalTransaction();
        return this.originalConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement statement = this.originalConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        return new StatementProxyXA(this, statement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement preparedStatement = this.originalConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return new PreparedStatementProxyXA(this, preparedStatement);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        RootContext.assertNotInGlobalTransaction();
        return this.originalConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement preparedStatement = this.originalConnection.prepareStatement(sql, autoGeneratedKeys);
        return new PreparedStatementProxyXA(this, preparedStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement preparedStatement = this.originalConnection.prepareStatement(sql, columnIndexes);
        return new PreparedStatementProxyXA(this, preparedStatement);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement preparedStatement = this.originalConnection.prepareStatement(sql, columnNames);
        return new PreparedStatementProxyXA(this, preparedStatement);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.originalConnection.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.originalConnection.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.originalConnection.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.originalConnection.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.originalConnection.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.originalConnection.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.originalConnection.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.originalConnection.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.originalConnection.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.originalConnection.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.originalConnection.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.originalConnection.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.originalConnection.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.originalConnection.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.originalConnection.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.originalConnection.getNetworkTimeout();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.originalConnection.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.originalConnection.isWrapperFor(iface);
    }
}

