/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.tcc.api;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.seata.core.model.BranchType;
import org.apache.seata.integration.tx.api.interceptor.ActionContextUtil;

public class BusinessActionContext
implements Serializable {
    private static final long serialVersionUID = 6539226288677737991L;
    private String xid;
    private String branchId;
    private String actionName;
    private Boolean isDelayReport;
    private Boolean isUpdated;
    private BranchType branchType;
    private Map<String, Object> actionContext;

    public BusinessActionContext() {
    }

    public BusinessActionContext(String xid, String branchId, Map<String, Object> actionContext) {
        this.xid = xid;
        this.branchId = branchId;
        this.actionContext = actionContext;
    }

    @Nullable
    public Object getActionContext(String key) {
        return this.actionContext.get(key);
    }

    @Nullable
    public <T> T getActionContext(String key, @Nonnull Class<T> targetClazz) {
        Object value = this.actionContext.get(key);
        return ActionContextUtil.convertActionContext(key, value, targetClazz);
    }

    public long getBranchId() {
        return this.branchId != null ? Long.parseLong(this.branchId) : -1L;
    }

    public void setBranchId(long branchId) {
        this.branchId = String.valueOf(branchId);
    }

    public void setBranchId(String branchId) {
        this.branchId = branchId;
    }

    public Map<String, Object> getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(Map<String, Object> actionContext) {
        this.actionContext = actionContext;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    @Deprecated
    public boolean addActionContext(String key, Object value) {
        boolean isChanged;
        if (value == null) {
            return false;
        }
        Object previousValue = this.actionContext.put(key, value);
        boolean bl = isChanged = !value.equals(previousValue);
        if (isChanged) {
            this.setUpdated(true);
        }
        return isChanged;
    }

    public Boolean getDelayReport() {
        return this.isDelayReport;
    }

    public void setDelayReport(Boolean delayReport) {
        this.isDelayReport = delayReport;
    }

    public Boolean getUpdated() {
        return this.isUpdated;
    }

    public void setUpdated(Boolean updated) {
        this.isUpdated = updated;
    }

    public BranchType getBranchType() {
        return this.branchType;
    }

    public void setBranchType(BranchType branchType) {
        this.branchType = branchType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[xid:").append(this.xid).append(",branch_Id:").append(this.branchId).append(",action_name:").append(this.actionName).append(",is_delay_report:").append(this.isDelayReport).append(",is_updated:").append(this.isDelayReport).append(",branch_type:").append((Object)this.branchType).append(",action_context:").append(this.actionContext).append("]");
        return sb.toString();
    }
}

