/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.rpc.http;

import io.netty.channel.ChannelHandlerContext;

public class HttpContext<T> {
    public static final String HTTP_1_1 = "HTTP/1.1";
    public static final String HTTP_2_0 = "HTTP/2.0";
    private T request;
    private ChannelHandlerContext context;
    private boolean keepAlive;
    private boolean async = false;
    private String httpVersion;

    public HttpContext(T request, ChannelHandlerContext context, boolean keepAlive, String httpVersion) {
        this.request = request;
        this.context = context;
        this.keepAlive = keepAlive;
        this.httpVersion = httpVersion;
    }

    public HttpContext(T request, ChannelHandlerContext context, boolean keepAlive) {
        this.request = request;
        this.context = context;
        this.keepAlive = keepAlive;
        this.httpVersion = HTTP_1_1;
    }

    public boolean isHttp2() {
        return HTTP_2_0.equals(this.httpVersion);
    }

    public T getRequest() {
        return this.request;
    }

    public void setRequest(T request) {
        this.request = request;
    }

    public ChannelHandlerContext getContext() {
        return this.context;
    }

    public void setContext(ChannelHandlerContext context) {
        this.context = context;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }
}

