/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.store;

public enum SessionMode {
    FILE("file"),
    DB("db"),
    REDIS("redis"),
    RAFT("raft");

    private String name;

    private SessionMode(String name) {
        this.name = name;
    }

    public static SessionMode get(String name) {
        for (SessionMode mode : SessionMode.values()) {
            if (!mode.getName().equalsIgnoreCase(name)) continue;
            return mode;
        }
        throw new IllegalArgumentException("unknown session mode:" + name);
    }

    public static boolean contains(String name) {
        try {
            return SessionMode.get(name) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getName() {
        return this.name;
    }
}

