/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.v0;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.seata.core.compressor.CompressorType;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.netty.ProtocolRpcMessage;
import org.apache.seata.core.serializer.SerializerType;

public class ProtocolRpcMessageV0
implements ProtocolRpcMessage {
    private static AtomicLong NEXT_ID = new AtomicLong(0L);
    private long id;
    private boolean isAsync;
    private boolean isRequest;
    private boolean isHeartbeat;
    private Object body;
    private byte messageType;
    private boolean isSeataCodec;

    public static long getNextMessageId() {
        return NEXT_ID.incrementAndGet();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean async) {
        this.isAsync = async;
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public void setRequest(boolean request) {
        this.isRequest = request;
    }

    public boolean isHeartbeat() {
        return this.isHeartbeat;
    }

    public void setHeartbeat(boolean heartbeat) {
        this.isHeartbeat = heartbeat;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public boolean isSeataCodec() {
        return this.isSeataCodec;
    }

    public void setSeataCodec(boolean seataCodec) {
        this.isSeataCodec = seataCodec;
    }

    public byte getMessageType() {
        return this.messageType;
    }

    public void setMessageType(byte messageType) {
        this.messageType = messageType;
    }

    @Override
    public RpcMessage protocolMsg2RpcMsg() {
        RpcMessage rpcMessage = new RpcMessage();
        rpcMessage.setMessageType(this.messageType);
        rpcMessage.setCompressor(CompressorType.NONE.getCode());
        byte codecType = this.isSeataCodec ? SerializerType.SEATA.getCode() : SerializerType.HESSIAN.getCode();
        rpcMessage.setCodec(codecType);
        if (this.isHeartbeat) {
            if (this.isRequest) {
                rpcMessage.setMessageType((byte)3);
            } else {
                rpcMessage.setMessageType((byte)4);
            }
        } else if (this.isRequest) {
            rpcMessage.setMessageType((byte)2);
        } else {
            rpcMessage.setMessageType((byte)1);
        }
        rpcMessage.setBody(this.body);
        rpcMessage.setId((int)this.id);
        return rpcMessage;
    }

    @Override
    public void rpcMsg2ProtocolMsg(RpcMessage rpcMessage) {
        this.body = rpcMessage.getBody();
        this.id = rpcMessage.getId();
        this.isRequest = this.isRequest(rpcMessage.getMessageType());
        this.isHeartbeat = this.isHeartbeat(rpcMessage.getMessageType());
        this.isSeataCodec = rpcMessage.getCodec() == SerializerType.SEATA.getCode();
        this.messageType = rpcMessage.getMessageType();
    }

    private boolean isHeartbeat(byte msgType) {
        return msgType == 3 || msgType == 4;
    }

    private boolean isRequest(byte msgType) {
        return msgType == 2 || msgType == 0;
    }
}

