/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry;

import java.util.Objects;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.discovery.registry.RegistryProvider;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.RegistryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistryFactory.class);

    public static RegistryService getInstance() {
        return RegistryFactoryHolder.INSTANCE;
    }

    private static RegistryService buildRegistryService() {
        String registryTypeName = ConfigurationFactory.CURRENT_FILE_INSTANCE.getConfig("registry.type");
        if (StringUtils.isBlank(registryTypeName)) {
            registryTypeName = RegistryType.File.name();
        }
        LOGGER.info("use registry center type: {}", (Object)registryTypeName);
        RegistryType registryType = RegistryType.getType(registryTypeName);
        return EnhancedServiceLoader.load(RegistryProvider.class, Objects.requireNonNull(registryType).name()).provide();
    }

    static /* synthetic */ RegistryService access$100() {
        return RegistryFactory.buildRegistryService();
    }

    private static class RegistryFactoryHolder {
        private static final RegistryService INSTANCE = RegistryFactory.access$100();

        private RegistryFactoryHolder() {
        }
    }
}

