/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.integration.grpc.interceptor.server;

import io.grpc.ServerCall;
import java.util.Map;
import java.util.Objects;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.context.RootContext;
import org.apache.seata.core.model.BranchType;

public class ServerListenerProxy<ReqT>
extends ServerCall.Listener<ReqT> {
    private ServerCall.Listener<ReqT> target;
    private final String xid;
    private final Map<String, String> context;

    public ServerListenerProxy(String xid, Map<String, String> context, ServerCall.Listener<ReqT> target) {
        Objects.requireNonNull(target);
        this.target = target;
        this.xid = xid;
        this.context = context;
    }

    public void onMessage(ReqT message) {
        this.target.onMessage(message);
    }

    public void onHalfClose() {
        this.cleanContext();
        if (StringUtils.isNotBlank(this.xid)) {
            RootContext.bind(this.xid);
            String branchType = this.context.get("TX_BRANCH_TYPE");
            if (StringUtils.equals(BranchType.TCC.name(), branchType)) {
                RootContext.bindBranchType(BranchType.TCC);
            }
        }
        this.target.onHalfClose();
    }

    public void onCancel() {
        this.target.onCancel();
    }

    public void onComplete() {
        this.target.onComplete();
    }

    public void onReady() {
        this.target.onReady();
    }

    private void cleanContext() {
        RootContext.unbind();
        BranchType previousBranchType = RootContext.getBranchType();
        if (BranchType.TCC == previousBranchType) {
            RootContext.unbindBranchType();
        }
    }
}

