/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.rm.datasource;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.model.Result;
import org.apache.seata.rm.datasource.sql.struct.Field;
import org.apache.seata.rm.datasource.sql.struct.Row;
import org.apache.seata.rm.datasource.sql.struct.TableRecords;
import org.apache.seata.rm.datasource.undo.AbstractUndoLogManager;
import org.apache.seata.sqlparser.struct.TableMeta;

public class DataCompareUtils {
    private DataCompareUtils() {
    }

    public static Result<Boolean> isFieldEquals(Field f0, Field f1) {
        if (f0 == null) {
            return Result.build(f1 == null);
        }
        if (f1 == null) {
            return Result.build(false);
        }
        if (StringUtils.equalsIgnoreCase(f0.getName(), f1.getName()) && f0.getType() == f1.getType()) {
            boolean result;
            if (f0.getValue() == null) {
                return Result.build(f1.getValue() == null);
            }
            if (f1.getValue() == null) {
                return Result.buildWithParams(false, "Field not equals, name {}, new value is null", f0.getName());
            }
            String currentSerializer = AbstractUndoLogManager.getCurrentSerializer();
            if (StringUtils.equals(currentSerializer, "fastjson")) {
                DataCompareUtils.convertType(f0, f1);
            }
            if (result = Objects.deepEquals(f0.getValue(), f1.getValue())) {
                return Result.ok();
            }
            return Result.buildWithParams(false, "Field not equals, name {}, old value {}, new value {}", f0.getName(), f0.getValue(), f1.getValue());
        }
        return Result.buildWithParams(false, "Field not equals, old name {} type {}, new name {} type {}", f0.getName(), f0.getType(), f1.getName(), f1.getType());
    }

    private static void convertType(Field f0, Field f1) {
        String[] strings;
        int f0Type = f0.getType();
        int f1Type = f1.getType();
        if (f0Type == 91 && f0.getValue().getClass().equals(String.class)) {
            strings = f0.getValue().toString().split(" ");
            f0.setValue(Date.valueOf(strings[0]));
        }
        if (f1Type == 91 && f1.getValue().getClass().equals(String.class)) {
            strings = f1.getValue().toString().split(" ");
            f1.setValue(Date.valueOf(strings[0]));
        }
        if (f0Type == 92 && f0.getValue().getClass().equals(String.class)) {
            f0.setValue(Time.valueOf(f0.getValue().toString()));
        }
        if (f1Type == 92 && f1.getValue().getClass().equals(String.class)) {
            f1.setValue(Time.valueOf(f1.getValue().toString()));
        }
        if (f0Type == 93 && f0.getValue().getClass().equals(String.class)) {
            if (f1.getValue().getClass().equals(LocalDateTime.class)) {
                f0.setValue(LocalDateTime.parse(f0.getValue().toString()));
            } else {
                f0.setValue(Timestamp.valueOf(f0.getValue().toString()));
            }
        }
        if (f1Type == 93 && f1.getValue().getClass().equals(String.class)) {
            f1.setValue(Timestamp.valueOf(f1.getValue().toString()));
        }
        if (f0Type == 3 && f0.getValue().getClass().equals(Integer.class)) {
            f0.setValue(new BigDecimal(f0.getValue().toString()));
        }
        if (f1Type == 3 && f1.getValue().getClass().equals(Integer.class)) {
            f1.setValue(new BigDecimal(f1.getValue().toString()));
        }
        if (f0Type == -5 && f0.getValue().getClass().equals(Integer.class)) {
            f0.setValue(Long.parseLong(f0.getValue().toString()));
        }
        if (f1Type == -5 && f1.getValue().getClass().equals(Integer.class)) {
            f1.setValue(Long.parseLong(f1.getValue().toString()));
        }
    }

    public static Result<Boolean> isRecordsEquals(TableRecords beforeImage, TableRecords afterImage) {
        if (beforeImage == null) {
            return Result.build(afterImage == null, null);
        }
        if (afterImage == null) {
            return Result.build(false, null);
        }
        if (beforeImage.getTableName().equalsIgnoreCase(afterImage.getTableName()) && CollectionUtils.isSizeEquals(beforeImage.getRows(), afterImage.getRows())) {
            if (CollectionUtils.isEmpty(beforeImage.getRows())) {
                return Result.ok();
            }
            return DataCompareUtils.compareRows(beforeImage.getTableMeta(), beforeImage.getRows(), afterImage.getRows());
        }
        return Result.build(false, null);
    }

    public static Result<Boolean> isRowsEquals(TableMeta tableMetaData, List<Row> oldRows, List<Row> newRows) {
        if (!CollectionUtils.isSizeEquals(oldRows, newRows)) {
            return Result.build(false, null);
        }
        return DataCompareUtils.compareRows(tableMetaData, oldRows, newRows);
    }

    private static Result<Boolean> compareRows(TableMeta tableMetaData, List<Row> oldRows, List<Row> newRows) {
        Map<String, Map<String, Field>> oldRowsMap = DataCompareUtils.rowListToMap(oldRows, tableMetaData.getPrimaryKeyOnlyName());
        Map<String, Map<String, Field>> newRowsMap = DataCompareUtils.rowListToMap(newRows, tableMetaData.getPrimaryKeyOnlyName());
        for (Map.Entry<String, Map<String, Field>> oldEntry : oldRowsMap.entrySet()) {
            String key = oldEntry.getKey();
            Map<String, Field> oldRow = oldEntry.getValue();
            Map<String, Field> newRow = newRowsMap.get(key);
            if (newRow == null) {
                return Result.buildWithParams(false, "compare row failed, rowKey {}, reason [newRow is null]", key);
            }
            for (Map.Entry<String, Field> oldRowEntry : oldRow.entrySet()) {
                String fieldName = oldRowEntry.getKey();
                Field oldField = oldRowEntry.getValue();
                Field newField = newRow.get(fieldName);
                if (newField == null) {
                    return Result.buildWithParams(false, "compare row failed, rowKey {}, fieldName {}, reason [newField is null]", key, fieldName);
                }
                Result<Boolean> oldEqualsNewFieldResult = DataCompareUtils.isFieldEquals(oldField, newField);
                if (oldEqualsNewFieldResult.getResult().booleanValue()) continue;
                return oldEqualsNewFieldResult;
            }
        }
        return Result.ok();
    }

    public static Map<String, Map<String, Field>> rowListToMap(List<Row> rowList, List<String> primaryKeyList) {
        HashMap<String, Map<String, Field>> rowMap = new HashMap<String, Map<String, Field>>();
        for (Row row : rowList) {
            List rowFieldList = row.getFields().stream().sorted(Comparator.comparing(Field::getName)).collect(Collectors.toList());
            HashMap<String, Field> colsMap = new HashMap<String, Field>();
            StringBuilder rowKey = new StringBuilder();
            boolean firstUnderline = false;
            for (int j = 0; j < rowFieldList.size(); ++j) {
                Field field = (Field)rowFieldList.get(j);
                if (primaryKeyList.stream().anyMatch(e -> field.getName().equals(e))) {
                    if (firstUnderline && j > 0) {
                        rowKey.append("_");
                    }
                    rowKey.append(String.valueOf(field.getValue()));
                    firstUnderline = true;
                }
                colsMap.put(field.getName().trim().toUpperCase(), field);
            }
            rowMap.put(rowKey.toString(), colsMap);
        }
        return rowMap;
    }
}

